/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices.alias.put;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.AliasAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.AcknowledgedRestResponseActionListener;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.XContentThrowableRestResponse;

public class RestIndexPutAliasAction
extends BaseRestHandler {
    @Inject
    public RestIndexPutAliasAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.PUT, "/{index}/_alias/{name}", this);
        controller.registerHandler(RestRequest.Method.PUT, "/_alias/{name}", this);
        controller.registerHandler(RestRequest.Method.PUT, "/{index}/_alias", this);
        controller.registerHandler(RestRequest.Method.PUT, "/_alias", this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRequest(RestRequest request, RestChannel channel) {
        String index = request.param("index");
        String alias = request.param("name");
        Map<String, Object> filter2 = null;
        String routing = null;
        String indexRouting = null;
        String searchRouting = null;
        if (request.hasContent()) {
            XContentParser parser = null;
            try {
                parser = XContentFactory.xContent(request.content()).createParser(request.content());
                XContentParser.Token token2 = parser.nextToken();
                if (token2 == null) {
                    throw new ElasticSearchIllegalArgumentException("No index alias is specified");
                }
                String currentFieldName = null;
                while ((token2 = parser.nextToken()) != null) {
                    if (token2 == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if (token2.isValue()) {
                        if ("index".equals(currentFieldName)) {
                            index = parser.text();
                            continue;
                        }
                        if ("alias".equals(currentFieldName)) {
                            alias = parser.text();
                            continue;
                        }
                        if ("routing".equals(currentFieldName)) {
                            routing = parser.textOrNull();
                            continue;
                        }
                        if ("indexRouting".equals(currentFieldName) || "index-routing".equals(currentFieldName) || "index_routing".equals(currentFieldName)) {
                            indexRouting = parser.textOrNull();
                            continue;
                        }
                        if (!"searchRouting".equals(currentFieldName) && !"search-routing".equals(currentFieldName) && !"search_routing".equals(currentFieldName)) continue;
                        searchRouting = parser.textOrNull();
                        continue;
                    }
                    if (token2 != XContentParser.Token.START_OBJECT || !"filter".equals(currentFieldName)) continue;
                    filter2 = parser.mapOrdered();
                }
            }
            catch (Throwable e) {
                try {
                    channel.sendResponse(new XContentThrowableRestResponse(request, e));
                }
                catch (IOException e1) {
                    this.logger.warn("Failed to send response", e1, new Object[0]);
                }
                return;
            }
            finally {
                if (parser != null) {
                    parser.close();
                }
            }
        }
        IndicesAliasesRequest indicesAliasesRequest = new IndicesAliasesRequest();
        indicesAliasesRequest.timeout(request.paramAsTime("timeout", indicesAliasesRequest.timeout()));
        AliasAction aliasAction = new AliasAction(AliasAction.Type.ADD, index, alias);
        indicesAliasesRequest.addAliasAction(aliasAction);
        indicesAliasesRequest.masterNodeTimeout(request.paramAsTime("master_timeout", indicesAliasesRequest.masterNodeTimeout()));
        if (routing != null) {
            aliasAction.routing(routing);
        }
        if (searchRouting != null) {
            aliasAction.searchRouting(searchRouting);
        }
        if (indexRouting != null) {
            aliasAction.indexRouting(indexRouting);
        }
        if (filter2 != null) {
            aliasAction.filter(filter2);
        }
        this.client.admin().indices().aliases(indicesAliasesRequest, new AcknowledgedRestResponseActionListener<IndicesAliasesResponse>(request, channel, this.logger));
    }
}

