/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices.alias;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.AliasAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.AcknowledgedRestResponseActionListener;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.XContentThrowableRestResponse;

public class RestIndicesAliasesAction
extends BaseRestHandler {
    @Inject
    public RestIndicesAliasesAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.POST, "/_aliases", this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRequest(RestRequest request, RestChannel channel) {
        IndicesAliasesRequest indicesAliasesRequest = new IndicesAliasesRequest();
        indicesAliasesRequest.listenerThreaded(false);
        indicesAliasesRequest.masterNodeTimeout(request.paramAsTime("master_timeout", indicesAliasesRequest.masterNodeTimeout()));
        XContentParser parser = null;
        try {
            indicesAliasesRequest.timeout(request.paramAsTime("timeout", indicesAliasesRequest.timeout()));
            parser = XContentFactory.xContent(request.content()).createParser(request.content());
            XContentParser.Token token2 = parser.nextToken();
            if (token2 == null) {
                throw new ElasticSearchIllegalArgumentException("No action is specified");
            }
            while ((token2 = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token2 != XContentParser.Token.START_ARRAY) continue;
                while ((token2 = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    AliasAction.Type type;
                    if (token2 != XContentParser.Token.FIELD_NAME) continue;
                    String action = parser.currentName();
                    if ("add".equals(action)) {
                        type = AliasAction.Type.ADD;
                    } else if ("remove".equals(action)) {
                        type = AliasAction.Type.REMOVE;
                    } else {
                        throw new ElasticSearchIllegalArgumentException("Alias action [" + action + "] not supported");
                    }
                    String index = null;
                    String alias = null;
                    Map<String, Object> filter2 = null;
                    String routing = null;
                    boolean routingSet = false;
                    String indexRouting = null;
                    boolean indexRoutingSet = false;
                    String searchRouting = null;
                    boolean searchRoutingSet = false;
                    String currentFieldName = null;
                    while ((token2 = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token2 == XContentParser.Token.FIELD_NAME) {
                            currentFieldName = parser.currentName();
                            continue;
                        }
                        if (token2 == XContentParser.Token.VALUE_STRING) {
                            if ("index".equals(currentFieldName)) {
                                index = parser.text();
                                continue;
                            }
                            if ("alias".equals(currentFieldName)) {
                                alias = parser.text();
                                continue;
                            }
                            if ("routing".equals(currentFieldName)) {
                                routing = parser.textOrNull();
                                routingSet = true;
                                continue;
                            }
                            if ("indexRouting".equals(currentFieldName) || "index-routing".equals(currentFieldName) || "index_routing".equals(currentFieldName)) {
                                indexRouting = parser.textOrNull();
                                indexRoutingSet = true;
                                continue;
                            }
                            if (!"searchRouting".equals(currentFieldName) && !"search-routing".equals(currentFieldName) && !"search_routing".equals(currentFieldName)) continue;
                            searchRouting = parser.textOrNull();
                            searchRoutingSet = true;
                            continue;
                        }
                        if (token2 != XContentParser.Token.START_OBJECT || !"filter".equals(currentFieldName)) continue;
                        filter2 = parser.mapOrdered();
                    }
                    if (type == AliasAction.Type.ADD) {
                        AliasAction aliasAction = AliasAction.newAddAliasAction(index, alias).filter(filter2);
                        if (routingSet) {
                            aliasAction.routing(routing);
                        }
                        if (indexRoutingSet) {
                            aliasAction.indexRouting(indexRouting);
                        }
                        if (searchRoutingSet) {
                            aliasAction.searchRouting(searchRouting);
                        }
                        indicesAliasesRequest.addAliasAction(aliasAction);
                        continue;
                    }
                    if (type != AliasAction.Type.REMOVE) continue;
                    indicesAliasesRequest.removeAlias(index, alias);
                }
            }
        }
        catch (Exception e) {
            try {
                channel.sendResponse(new XContentThrowableRestResponse(request, e));
            }
            catch (IOException e1) {
                this.logger.warn("Failed to send response", e1, new Object[0]);
            }
            return;
        }
        finally {
            parser.close();
        }
        this.client.admin().indices().aliases(indicesAliasesRequest, new AcknowledgedRestResponseActionListener<IndicesAliasesResponse>(request, channel, this.logger));
    }
}

