/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.cluster.node.restart;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.node.restart.NodesRestartRequest;
import org.elasticsearch.action.admin.cluster.node.restart.NodesRestartResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.XContentRestResponse;
import org.elasticsearch.rest.XContentThrowableRestResponse;
import org.elasticsearch.rest.action.support.RestXContentBuilder;

public class RestNodesRestartAction
extends BaseRestHandler {
    @Inject
    public RestNodesRestartAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.POST, "/_cluster/nodes/_restart", this);
        controller.registerHandler(RestRequest.Method.POST, "/_cluster/nodes/{nodeId}/_restart", this);
    }

    @Override
    public void handleRequest(final RestRequest request, final RestChannel channel) {
        String[] nodesIds = Strings.splitStringByCommaToArray(request.param("nodeId"));
        NodesRestartRequest nodesRestartRequest = new NodesRestartRequest(nodesIds);
        nodesRestartRequest.listenerThreaded(false);
        nodesRestartRequest.delay(request.paramAsTime("delay", nodesRestartRequest.delay()));
        this.client.admin().cluster().nodesRestart(nodesRestartRequest, new ActionListener<NodesRestartResponse>(){

            @Override
            public void onResponse(NodesRestartResponse result2) {
                try {
                    XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                    builder.startObject();
                    builder.field("cluster_name", result2.getClusterName().value());
                    builder.startObject("nodes");
                    for (NodesRestartResponse.NodeRestartResponse nodeInfo : result2) {
                        builder.startObject(nodeInfo.getNode().id());
                        builder.field("name", nodeInfo.getNode().name());
                        builder.endObject();
                    }
                    builder.endObject();
                    builder.endObject();
                    channel.sendResponse(new XContentRestResponse(request, RestStatus.OK, builder));
                }
                catch (Throwable e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Throwable e) {
                try {
                    channel.sendResponse(new XContentThrowableRestResponse(request, e));
                }
                catch (IOException e1) {
                    RestNodesRestartAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                }
            }
        });
    }
}

