/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest;

import java.io.IOException;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.rest.AbstractRestResponseActionListener;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.XContentRestResponse;
import org.elasticsearch.rest.action.support.RestXContentBuilder;

public class AcknowledgedRestResponseActionListener<T extends AcknowledgedResponse>
extends AbstractRestResponseActionListener<T> {
    public AcknowledgedRestResponseActionListener(RestRequest request, RestChannel channel, ESLogger logger) {
        super(request, channel, logger);
    }

    @Override
    public void onResponse(T response) {
        try {
            XContentBuilder builder = RestXContentBuilder.restContentBuilder(this.request);
            builder.startObject().field(Fields.OK, true).field(Fields.ACKNOWLEDGED, ((AcknowledgedResponse)response).isAcknowledged());
            this.addCustomFields(builder, response);
            builder.endObject();
            this.channel.sendResponse(new XContentRestResponse(this.request, RestStatus.OK, builder));
        }
        catch (IOException e) {
            this.onFailure(e);
        }
    }

    protected void addCustomFields(XContentBuilder builder, T response) throws IOException {
    }

    static final class Fields {
        static final XContentBuilderString OK = new XContentBuilderString("ok");
        static final XContentBuilderString ACKNOWLEDGED = new XContentBuilderString("acknowledged");

        Fields() {
        }
    }
}

