/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.routing.MutableShardRouting;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.StopWatch;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.deletionpolicy.SnapshotIndexCommit;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.shard.IllegalIndexShardStateException;
import org.elasticsearch.index.shard.IndexShardClosedException;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.service.InternalIndexShard;
import org.elasticsearch.index.store.StoreFileMetaData;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.recovery.DelayRecoveryException;
import org.elasticsearch.indices.recovery.RecoverFilesRecoveryException;
import org.elasticsearch.indices.recovery.RecoveryCleanFilesRequest;
import org.elasticsearch.indices.recovery.RecoveryFileChunkRequest;
import org.elasticsearch.indices.recovery.RecoveryFilesInfoRequest;
import org.elasticsearch.indices.recovery.RecoveryFinalizeRecoveryRequest;
import org.elasticsearch.indices.recovery.RecoveryPrepareForTranslogOperationsRequest;
import org.elasticsearch.indices.recovery.RecoveryResponse;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.indices.recovery.RecoveryTranslogOperationsRequest;
import org.elasticsearch.indices.recovery.StartRecoveryRequest;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.EmptyTransportResponseHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportService;

public class RecoverySource
extends AbstractComponent {
    private final TransportService transportService;
    private final IndicesService indicesService;
    private final RecoverySettings recoverySettings;
    private final ClusterService clusterService;
    private final TimeValue internalActionTimeout;
    private final TimeValue internalActionLongTimeout;

    @Inject
    public RecoverySource(Settings settings, TransportService transportService, IndicesService indicesService, RecoverySettings recoverySettings, ClusterService clusterService) {
        super(settings);
        this.transportService = transportService;
        this.indicesService = indicesService;
        this.clusterService = clusterService;
        this.recoverySettings = recoverySettings;
        transportService.registerHandler("index/shard/recovery/startRecovery", new StartRecoveryTransportRequestHandler());
        this.internalActionTimeout = this.componentSettings.getAsTime("internal_action_timeout", TimeValue.timeValueMinutes(15L));
        this.internalActionLongTimeout = new TimeValue(this.internalActionTimeout.millis() * 2L);
    }

    private RecoveryResponse recover(final StartRecoveryRequest request) {
        final InternalIndexShard shard = (InternalIndexShard)this.indicesService.indexServiceSafe(request.shardId().index().name()).shardSafe(request.shardId().id());
        RoutingNode node = this.clusterService.state().readOnlyRoutingNodes().node(request.targetNode().id());
        if (node == null) {
            throw new DelayRecoveryException("source node does not have the node [" + request.targetNode() + "] in its state yet..");
        }
        ShardRouting targetShardRouting = null;
        for (MutableShardRouting shardRouting : node) {
            if (!shardRouting.shardId().equals(request.shardId())) continue;
            targetShardRouting = shardRouting;
            break;
        }
        if (targetShardRouting == null) {
            throw new DelayRecoveryException("source node does not have the shard listed in its state as allocated on the node");
        }
        if (!targetShardRouting.initializing()) {
            throw new DelayRecoveryException("source node has the state of the target shard to be [" + (Object)((Object)targetShardRouting.state()) + "], expecting to be [initializing]");
        }
        this.logger.trace("[{}][{}] starting recovery to {}, mark_as_relocated {}", request.shardId().index().name(), request.shardId().id(), request.targetNode(), request.markAsRelocated());
        final RecoveryResponse response = new RecoveryResponse();
        shard.recover(new Engine.RecoveryHandler(){

            @Override
            public void phase1(SnapshotIndexCommit snapshot) throws ElasticSearchException {
                long totalSize = 0L;
                long existingTotalSize = 0L;
                try {
                    StopWatch stopWatch = new StopWatch().start();
                    for (String name : snapshot.getFiles()) {
                        StoreFileMetaData md = shard.store().metaData(name);
                        boolean useExisting = false;
                        if (request.existingFiles().containsKey(name) && !name.startsWith("segments") && md.isSame(request.existingFiles().get(name))) {
                            response.phase1ExistingFileNames.add(name);
                            response.phase1ExistingFileSizes.add(md.length());
                            existingTotalSize += md.length();
                            useExisting = true;
                            if (RecoverySource.this.logger.isTraceEnabled()) {
                                RecoverySource.this.logger.trace("[{}][{}] recovery [phase1] to {}: not recovering [{}], exists in local store and has checksum [{}], size [{}]", request.shardId().index().name(), request.shardId().id(), request.targetNode(), name, md.checksum(), md.length());
                            }
                        }
                        if (!useExisting) {
                            if (request.existingFiles().containsKey(name)) {
                                RecoverySource.this.logger.trace("[{}][{}] recovery [phase1] to {}: recovering [{}], exists in local store, but is different: remote [{}], local [{}]", request.shardId().index().name(), request.shardId().id(), request.targetNode(), name, request.existingFiles().get(name), md);
                            } else {
                                RecoverySource.this.logger.trace("[{}][{}] recovery [phase1] to {}: recovering [{}], does not exists in remote", request.shardId().index().name(), request.shardId().id(), request.targetNode(), name);
                            }
                            response.phase1FileNames.add(name);
                            response.phase1FileSizes.add(md.length());
                        }
                        totalSize += md.length();
                    }
                    response.phase1TotalSize = totalSize;
                    response.phase1ExistingTotalSize = existingTotalSize;
                    RecoverySource.this.logger.trace("[{}][{}] recovery [phase1] to {}: recovering_files [{}] with total_size [{}], reusing_files [{}] with total_size [{}]", request.shardId().index().name(), request.shardId().id(), request.targetNode(), response.phase1FileNames.size(), new ByteSizeValue(totalSize), response.phase1ExistingFileNames.size(), new ByteSizeValue(existingTotalSize));
                    RecoveryFilesInfoRequest recoveryInfoFilesRequest = new RecoveryFilesInfoRequest(request.recoveryId(), request.shardId(), response.phase1FileNames, response.phase1FileSizes, response.phase1ExistingFileNames, response.phase1ExistingFileSizes, response.phase1TotalSize, response.phase1ExistingTotalSize);
                    RecoverySource.this.transportService.submitRequest(request.targetNode(), "index/shard/recovery/filesInfo", recoveryInfoFilesRequest, TransportRequestOptions.options().withTimeout(RecoverySource.this.internalActionTimeout), EmptyTransportResponseHandler.INSTANCE_SAME).txGet();
                    final CountDownLatch latch = new CountDownLatch(response.phase1FileNames.size());
                    final AtomicReference lastException = new AtomicReference();
                    int fileIndex = 0;
                    for (final String name : response.phase1FileNames) {
                        long fileSize = response.phase1FileSizes.get(fileIndex);
                        RecoverySource.this.recoverySettings;
                        ThreadPoolExecutor pool = fileSize > RecoverySettings.SMALL_FILE_CUTOFF_BYTES ? RecoverySource.this.recoverySettings.concurrentStreamPool() : RecoverySource.this.recoverySettings.concurrentSmallFileStreamPool();
                        pool.execute(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                IndexInput indexInput = null;
                                try {
                                    int toRead;
                                    int BUFFER_SIZE = (int)RecoverySource.this.recoverySettings.fileChunkSize().bytes();
                                    byte[] buf = new byte[BUFFER_SIZE];
                                    StoreFileMetaData md = shard.store().metaData(name);
                                    indexInput = shard.store().openInputRaw(name, IOContext.READ);
                                    boolean shouldCompressRequest = RecoverySource.this.recoverySettings.compress();
                                    if (CompressorFactory.isCompressed(indexInput)) {
                                        shouldCompressRequest = false;
                                    }
                                    long len = indexInput.length();
                                    for (long readCount = 0L; readCount < len; readCount += (long)toRead) {
                                        if (shard.state() == IndexShardState.CLOSED) {
                                            throw new IndexShardClosedException(shard.shardId());
                                        }
                                        toRead = readCount + (long)BUFFER_SIZE > len ? (int)(len - readCount) : BUFFER_SIZE;
                                        long position = indexInput.getFilePointer();
                                        if (RecoverySource.this.recoverySettings.rateLimiter() != null) {
                                            RecoverySource.this.recoverySettings.rateLimiter().pause(toRead);
                                        }
                                        indexInput.readBytes(buf, 0, toRead, false);
                                        BytesArray content = new BytesArray(buf, 0, toRead);
                                        RecoverySource.this.transportService.submitRequest(request.targetNode(), "index/shard/recovery/fileChunk", new RecoveryFileChunkRequest(request.recoveryId(), request.shardId(), name, position, len, md.checksum(), content), TransportRequestOptions.options().withCompress(shouldCompressRequest).withType(TransportRequestOptions.Type.RECOVERY).withTimeout(RecoverySource.this.internalActionTimeout), EmptyTransportResponseHandler.INSTANCE_SAME).txGet();
                                    }
                                }
                                catch (Throwable e) {
                                    try {
                                        lastException.set(e);
                                    }
                                    catch (Throwable throwable) {
                                        IOUtils.closeWhileHandlingException(indexInput);
                                        latch.countDown();
                                        throw throwable;
                                    }
                                    IOUtils.closeWhileHandlingException(indexInput);
                                    latch.countDown();
                                }
                                IOUtils.closeWhileHandlingException(indexInput);
                                latch.countDown();
                            }
                        });
                        ++fileIndex;
                    }
                    latch.await();
                    if (lastException.get() != null) {
                        throw (Throwable)lastException.get();
                    }
                    HashSet<String> snapshotFiles = Sets.newHashSet(snapshot.getFiles());
                    RecoverySource.this.transportService.submitRequest(request.targetNode(), "index/shard/recovery/cleanFiles", new RecoveryCleanFilesRequest(request.recoveryId(), shard.shardId(), snapshotFiles), TransportRequestOptions.options().withTimeout(RecoverySource.this.internalActionTimeout), EmptyTransportResponseHandler.INSTANCE_SAME).txGet();
                    stopWatch.stop();
                    RecoverySource.this.logger.trace("[{}][{}] recovery [phase1] to {}: took [{}]", request.shardId().index().name(), request.shardId().id(), request.targetNode(), stopWatch.totalTime());
                    response.phase1Time = stopWatch.totalTime().millis();
                }
                catch (Throwable e) {
                    throw new RecoverFilesRecoveryException(request.shardId(), response.phase1FileNames.size(), new ByteSizeValue(totalSize), e);
                }
            }

            @Override
            public void phase2(Translog.Snapshot snapshot) throws ElasticSearchException {
                if (shard.state() == IndexShardState.CLOSED) {
                    throw new IndexShardClosedException(request.shardId());
                }
                RecoverySource.this.logger.trace("[{}][{}] recovery [phase2] to {}: start", request.shardId().index().name(), request.shardId().id(), request.targetNode());
                StopWatch stopWatch = new StopWatch().start();
                RecoverySource.this.transportService.submitRequest(request.targetNode(), "index/shard/recovery/prepareTranslog", new RecoveryPrepareForTranslogOperationsRequest(request.recoveryId(), request.shardId()), TransportRequestOptions.options().withTimeout(RecoverySource.this.internalActionTimeout), EmptyTransportResponseHandler.INSTANCE_SAME).txGet();
                stopWatch.stop();
                response.startTime = stopWatch.totalTime().millis();
                RecoverySource.this.logger.trace("[{}][{}] recovery [phase2] to {}: start took [{}]", request.shardId().index().name(), request.shardId().id(), request.targetNode(), stopWatch.totalTime());
                RecoverySource.this.logger.trace("[{}][{}] recovery [phase2] to {}: sending transaction log operations", request.shardId().index().name(), request.shardId().id(), request.targetNode());
                stopWatch = new StopWatch().start();
                int totalOperations = this.sendSnapshot(snapshot);
                stopWatch.stop();
                RecoverySource.this.logger.trace("[{}][{}] recovery [phase2] to {}: took [{}]", request.shardId().index().name(), request.shardId().id(), request.targetNode(), stopWatch.totalTime());
                response.phase2Time = stopWatch.totalTime().millis();
                response.phase2Operations = totalOperations;
            }

            @Override
            public void phase3(Translog.Snapshot snapshot) throws ElasticSearchException {
                if (shard.state() == IndexShardState.CLOSED) {
                    throw new IndexShardClosedException(request.shardId());
                }
                RecoverySource.this.logger.trace("[{}][{}] recovery [phase3] to {}: sending transaction log operations", request.shardId().index().name(), request.shardId().id(), request.targetNode());
                StopWatch stopWatch = new StopWatch().start();
                int totalOperations = this.sendSnapshot(snapshot);
                RecoverySource.this.transportService.submitRequest(request.targetNode(), "index/shard/recovery/finalize", new RecoveryFinalizeRecoveryRequest(request.recoveryId(), request.shardId()), TransportRequestOptions.options().withTimeout(RecoverySource.this.internalActionLongTimeout), EmptyTransportResponseHandler.INSTANCE_SAME).txGet();
                if (request.markAsRelocated()) {
                    try {
                        shard.relocated("to " + request.targetNode());
                    }
                    catch (IllegalIndexShardStateException e) {
                        // empty catch block
                    }
                }
                stopWatch.stop();
                RecoverySource.this.logger.trace("[{}][{}] recovery [phase3] to {}: took [{}]", request.shardId().index().name(), request.shardId().id(), request.targetNode(), stopWatch.totalTime());
                response.phase3Time = stopWatch.totalTime().millis();
                response.phase3Operations = totalOperations;
            }

            private int sendSnapshot(Translog.Snapshot snapshot) throws ElasticSearchException {
                int ops2 = 0;
                long size2 = 0L;
                int totalOperations = 0;
                ArrayList<Translog.Operation> operations = Lists.newArrayList();
                while (snapshot.hasNext()) {
                    if (shard.state() == IndexShardState.CLOSED) {
                        throw new IndexShardClosedException(request.shardId());
                    }
                    Translog.Operation operation = snapshot.next();
                    operations.add(operation);
                    ++totalOperations;
                    if (++ops2 < RecoverySource.this.recoverySettings.translogOps() && (size2 += operation.estimateSize()) < RecoverySource.this.recoverySettings.translogSize().bytes()) continue;
                    if (RecoverySource.this.recoverySettings.rateLimiter() != null) {
                        RecoverySource.this.recoverySettings.rateLimiter().pause(size2);
                    }
                    RecoveryTranslogOperationsRequest translogOperationsRequest = new RecoveryTranslogOperationsRequest(request.recoveryId(), request.shardId(), operations);
                    RecoverySource.this.transportService.submitRequest(request.targetNode(), "index/shard/recovery/translogOps", translogOperationsRequest, TransportRequestOptions.options().withCompress(RecoverySource.this.recoverySettings.compress()).withType(TransportRequestOptions.Type.RECOVERY).withTimeout(RecoverySource.this.internalActionLongTimeout), EmptyTransportResponseHandler.INSTANCE_SAME).txGet();
                    ops2 = 0;
                    size2 = 0L;
                    operations.clear();
                }
                if (!operations.isEmpty()) {
                    RecoveryTranslogOperationsRequest translogOperationsRequest = new RecoveryTranslogOperationsRequest(request.recoveryId(), request.shardId(), operations);
                    RecoverySource.this.transportService.submitRequest(request.targetNode(), "index/shard/recovery/translogOps", translogOperationsRequest, TransportRequestOptions.options().withCompress(RecoverySource.this.recoverySettings.compress()).withType(TransportRequestOptions.Type.RECOVERY).withTimeout(RecoverySource.this.internalActionLongTimeout), EmptyTransportResponseHandler.INSTANCE_SAME).txGet();
                }
                return totalOperations;
            }
        });
        return response;
    }

    class StartRecoveryTransportRequestHandler
    extends BaseTransportRequestHandler<StartRecoveryRequest> {
        StartRecoveryTransportRequestHandler() {
        }

        @Override
        public StartRecoveryRequest newInstance() {
            return new StartRecoveryRequest();
        }

        @Override
        public String executor() {
            return "generic";
        }

        @Override
        public void messageReceived(StartRecoveryRequest request, TransportChannel channel) throws Exception {
            RecoveryResponse response = RecoverySource.this.recover(request);
            channel.sendResponse(response);
        }
    }

    public static class Actions {
        public static final String START_RECOVERY = "index/shard/recovery/startRecovery";
    }
}

