/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.io.IOException;
import java.util.Set;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.transport.TransportRequest;

class RecoveryCleanFilesRequest
extends TransportRequest {
    private long recoveryId;
    private ShardId shardId;
    private Set<String> snapshotFiles;

    RecoveryCleanFilesRequest() {
    }

    RecoveryCleanFilesRequest(long recoveryId, ShardId shardId, Set<String> snapshotFiles) {
        this.recoveryId = recoveryId;
        this.shardId = shardId;
        this.snapshotFiles = snapshotFiles;
    }

    public long recoveryId() {
        return this.recoveryId;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    public Set<String> snapshotFiles() {
        return this.snapshotFiles;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.recoveryId = in.readLong();
        this.shardId = ShardId.readShardId(in);
        int size2 = in.readVInt();
        this.snapshotFiles = Sets.newHashSetWithExpectedSize(size2);
        for (int i = 0; i < size2; ++i) {
            this.snapshotFiles.add(in.readString());
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.recoveryId);
        this.shardId.writeTo(out);
        out.writeVInt(this.snapshotFiles.size());
        for (String snapshotFile : this.snapshotFiles) {
            out.writeString(snapshotFile);
        }
    }
}

