/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.cluster;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.action.index.NodeIndexDeletedAction;
import org.elasticsearch.cluster.action.index.NodeMappingRefreshAction;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.MutableShardRouting;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.compress.CompressedString;
import org.elasticsearch.common.hppc.IntOpenHashSet;
import org.elasticsearch.common.hppc.ObjectContainer;
import org.elasticsearch.common.hppc.cursors.ObjectCursor;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.index.IndexShardAlreadyExistsException;
import org.elasticsearch.index.IndexShardMissingException;
import org.elasticsearch.index.aliases.IndexAlias;
import org.elasticsearch.index.aliases.IndexAliasesService;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.gateway.IndexShardGatewayRecoveryException;
import org.elasticsearch.index.gateway.IndexShardGatewayService;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.settings.IndexSettingsService;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.index.shard.service.InternalIndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.recovery.RecoveryFailedException;
import org.elasticsearch.indices.recovery.RecoveryStatus;
import org.elasticsearch.indices.recovery.RecoveryTarget;
import org.elasticsearch.indices.recovery.StartRecoveryRequest;
import org.elasticsearch.threadpool.ThreadPool;

public class IndicesClusterStateService
extends AbstractLifecycleComponent<IndicesClusterStateService>
implements ClusterStateListener {
    private final IndicesService indicesService;
    private final ClusterService clusterService;
    private final ThreadPool threadPool;
    private final RecoveryTarget recoveryTarget;
    private final ShardStateAction shardStateAction;
    private final NodeIndexDeletedAction nodeIndexDeletedAction;
    private final NodeMappingRefreshAction nodeMappingRefreshAction;
    private final ConcurrentMap<Tuple<String, String>, Boolean> seenMappings = ConcurrentCollections.newConcurrentMap();
    private final ConcurrentMap<ShardId, FailedShard> failedShards = ConcurrentCollections.newConcurrentMap();
    private final Object mutex = new Object();
    private final FailedEngineHandler failedEngineHandler = new FailedEngineHandler();
    private final boolean sendRefreshMapping;

    @Inject
    public IndicesClusterStateService(Settings settings, IndicesService indicesService, ClusterService clusterService, ThreadPool threadPool, RecoveryTarget recoveryTarget, ShardStateAction shardStateAction, NodeIndexDeletedAction nodeIndexDeletedAction, NodeMappingRefreshAction nodeMappingRefreshAction) {
        super(settings);
        this.indicesService = indicesService;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.recoveryTarget = recoveryTarget;
        this.shardStateAction = shardStateAction;
        this.nodeIndexDeletedAction = nodeIndexDeletedAction;
        this.nodeMappingRefreshAction = nodeMappingRefreshAction;
        this.sendRefreshMapping = this.componentSettings.getAsBoolean("send_refresh_mapping", (Boolean)true);
    }

    @Override
    protected void doStart() throws ElasticSearchException {
        this.clusterService.addFirst(this);
    }

    @Override
    protected void doStop() throws ElasticSearchException {
        this.clusterService.remove(this);
    }

    @Override
    protected void doClose() throws ElasticSearchException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        if (!this.indicesService.changesAllowed()) {
            return;
        }
        if (!this.lifecycle.started()) {
            return;
        }
        Object object = this.mutex;
        synchronized (object) {
            if (event.state().blocks().disableStatePersistence()) {
                for (String index : this.indicesService.indices()) {
                    IndexService indexService = this.indicesService.indexService(index);
                    for (Integer shardId : indexService.shardIds()) {
                        this.logger.debug("[{}][{}] removing shard (disabled block persistence)", index, shardId);
                        try {
                            indexService.removeShard(shardId, "removing shard (disabled block persistence)");
                        }
                        catch (Throwable e) {
                            this.logger.warn("[{}] failed to remove shard (disabled block persistence)", e, index);
                        }
                    }
                    this.removeIndex(index, "cleaning index (disabled block persistence)");
                }
                return;
            }
            this.cleanFailedShards(event);
            this.cleanMismatchedIndexUUIDs(event);
            this.applyNewIndices(event);
            this.applyMappings(event);
            this.applyAliases(event);
            this.applyNewOrUpdatedShards(event);
            this.applyDeletedIndices(event);
            this.applyDeletedShards(event);
            this.applyCleanedIndices(event);
            this.applySettings(event);
            this.sendIndexLifecycleEvents(event);
        }
    }

    private void sendIndexLifecycleEvents(ClusterChangedEvent event) {
        String localNodeId = event.state().nodes().localNodeId();
        assert (localNodeId != null);
        for (String index : event.indicesDeleted()) {
            try {
                this.nodeIndexDeletedAction.nodeIndexDeleted(event.state(), index, localNodeId);
            }
            catch (Throwable e) {
                this.logger.debug("failed to send to master index {} deleted event", e, index);
            }
        }
    }

    private void cleanMismatchedIndexUUIDs(ClusterChangedEvent event) {
        for (IndexService indexService : this.indicesService) {
            IndexMetaData indexMetaData = event.state().metaData().index(indexService.index().name());
            if (indexMetaData == null || indexMetaData.isSameUUID(indexService.indexUUID())) continue;
            this.logger.debug("[{}] mismatch on index UUIDs between cluster state and local state, cleaning the index so it will be recreated", indexMetaData.index());
            this.removeIndex(indexMetaData.index(), "mismatch on index UUIDs between cluster state and local state, cleaning the index so it will be recreated");
        }
    }

    private void applyCleanedIndices(ClusterChangedEvent event) {
        for (String index : this.indicesService.indices()) {
            IndexMetaData indexMetaData = event.state().metaData().index(index);
            if (indexMetaData == null || indexMetaData.state() != IndexMetaData.State.CLOSE) continue;
            IndexService indexService = this.indicesService.indexService(index);
            for (Integer shardId : indexService.shardIds()) {
                this.logger.debug("[{}][{}] removing shard (index is closed)", index, shardId);
                try {
                    indexService.removeShard(shardId, "removing shard (index is closed)");
                }
                catch (Throwable e) {
                    this.logger.warn("[{}] failed to remove shard (index is closed)", e, index);
                }
            }
        }
        for (String index : this.indicesService.indices()) {
            if (!this.indicesService.indexService(index).shardIds().isEmpty()) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("[{}] cleaning index (no shards allocated)", index);
            }
            this.removeIndex(index, "removing index (no shards allocated)");
        }
    }

    private void applyDeletedIndices(ClusterChangedEvent event) {
        for (String index : this.indicesService.indices()) {
            if (event.state().metaData().hasIndex(index)) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("[{}] cleaning index, no longer part of the metadata", index);
            }
            this.removeIndex(index, "index no longer part of the metadata");
        }
    }

    private void applyDeletedShards(ClusterChangedEvent event) {
        RoutingNodes.RoutingNodeIterator routingNode = event.state().readOnlyRoutingNodes().routingNodeIter(event.state().nodes().localNodeId());
        if (routingNode == null) {
            return;
        }
        IntOpenHashSet newShardIds = new IntOpenHashSet();
        for (IndexService indexService : this.indicesService) {
            String index = indexService.index().name();
            IndexMetaData indexMetaData = event.state().metaData().index(index);
            if (indexMetaData == null) continue;
            newShardIds.clear();
            for (MutableShardRouting shard : routingNode) {
                if (!shard.index().equals(index)) continue;
                newShardIds.add(shard.id());
            }
            for (Integer existingShardId : indexService.shardIds()) {
                if (newShardIds.contains(existingShardId)) continue;
                if (indexMetaData.state() == IndexMetaData.State.CLOSE) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("[{}][{}] removing shard (index is closed)", index, existingShardId);
                    }
                    indexService.removeShard(existingShardId, "removing shard (index is closed)");
                    continue;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("[{}][{}] removing shard (not allocated)", index, existingShardId);
                }
                indexService.removeShard(existingShardId, "removing shard (not allocated)");
            }
        }
    }

    private void applyNewIndices(ClusterChangedEvent event) {
        RoutingNodes.RoutingNodeIterator routingNode = event.state().readOnlyRoutingNodes().routingNodeIter(event.state().nodes().localNodeId());
        if (routingNode == null) {
            return;
        }
        for (MutableShardRouting shard : routingNode) {
            if (this.indicesService.hasIndex(shard.index())) continue;
            IndexMetaData indexMetaData = event.state().metaData().index(shard.index());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("[{}] creating index", indexMetaData.index());
            }
            this.indicesService.createIndex(indexMetaData.index(), indexMetaData.settings(), event.state().nodes().localNode().id());
        }
    }

    private void applySettings(ClusterChangedEvent event) {
        if (!event.metaDataChanged()) {
            return;
        }
        for (IndexMetaData indexMetaData : event.state().metaData()) {
            if (!this.indicesService.hasIndex(indexMetaData.index()) || !event.indexMetaDataChanged(indexMetaData)) continue;
            String index = indexMetaData.index();
            IndexService indexService = this.indicesService.indexServiceSafe(index);
            IndexSettingsService indexSettingsService = indexService.injector().getInstance(IndexSettingsService.class);
            indexSettingsService.refreshSettings(indexMetaData.settings());
        }
    }

    private void applyMappings(ClusterChangedEvent event) {
        for (IndexMetaData indexMetaData : event.state().metaData()) {
            if (!this.indicesService.hasIndex(indexMetaData.index())) continue;
            ArrayList<String> typesToRefresh = null;
            String index = indexMetaData.index();
            IndexService indexService = this.indicesService.indexService(index);
            if (indexService == null) {
                return;
            }
            MapperService mapperService = indexService.mapperService();
            if (indexMetaData.mappings().containsKey("_default_")) {
                this.processMapping(index, mapperService, "_default_", indexMetaData.mapping("_default_").source());
            }
            for (ObjectCursor<MappingMetaData> objectCursor : indexMetaData.mappings().values()) {
                boolean requireRefresh;
                MappingMetaData mappingMd = (MappingMetaData)objectCursor.value;
                String mappingType = mappingMd.type();
                CompressedString mappingSource = mappingMd.source();
                if (mappingType.equals("_default_") || !(requireRefresh = this.processMapping(index, mapperService, mappingType, mappingSource))) continue;
                if (typesToRefresh == null) {
                    typesToRefresh = Lists.newArrayList();
                }
                typesToRefresh.add(mappingType);
            }
            if (typesToRefresh != null && this.sendRefreshMapping) {
                this.nodeMappingRefreshAction.nodeMappingRefresh(event.state(), new NodeMappingRefreshAction.NodeMappingRefreshRequest(index, indexMetaData.uuid(), typesToRefresh.toArray(new String[typesToRefresh.size()]), event.state().nodes().localNodeId()));
            }
            for (DocumentMapper documentMapper : mapperService) {
                if (!this.seenMappings.containsKey(new Tuple<String, String>(index, documentMapper.type())) || indexMetaData.mappings().containsKey(documentMapper.type())) continue;
                mapperService.remove(documentMapper.type());
                this.seenMappings.remove(new Tuple<String, String>(index, documentMapper.type()));
            }
        }
    }

    private boolean processMapping(String index, MapperService mapperService, String mappingType, CompressedString mappingSource) {
        if (!this.seenMappings.containsKey(new Tuple<String, String>(index, mappingType))) {
            this.seenMappings.put(new Tuple<String, String>(index, mappingType), true);
        }
        boolean requiresRefresh = false;
        try {
            if (!mapperService.hasMapping(mappingType)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("[{}] adding mapping [{}], source [{}]", index, mappingType, mappingSource.string());
                }
                mapperService.merge(mappingType, mappingSource, false);
                if (!mapperService.documentMapper(mappingType).mappingSource().equals(mappingSource)) {
                    this.logger.debug("[{}] parsed mapping [{}], and got different sources\noriginal:\n{}\nparsed:\n{}", index, mappingType, mappingSource, mapperService.documentMapper(mappingType).mappingSource());
                    requiresRefresh = true;
                }
            } else {
                DocumentMapper existingMapper = mapperService.documentMapper(mappingType);
                if (!mappingSource.equals(existingMapper.mappingSource())) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("[{}] updating mapping [{}], source [{}]", index, mappingType, mappingSource.string());
                    }
                    mapperService.merge(mappingType, mappingSource, false);
                    if (!mapperService.documentMapper(mappingType).mappingSource().equals(mappingSource)) {
                        requiresRefresh = true;
                        this.logger.debug("[{}] parsed mapping [{}], and got different sources\noriginal:\n{}\nparsed:\n{}", index, mappingType, mappingSource, mapperService.documentMapper(mappingType).mappingSource());
                    }
                }
            }
        }
        catch (Throwable e) {
            this.logger.warn("[{}] failed to add mapping [{}], source [{}]", e, index, mappingType, mappingSource);
        }
        return requiresRefresh;
    }

    private boolean aliasesChanged(ClusterChangedEvent event) {
        return !event.state().metaData().aliases().equals(event.previousState().metaData().aliases()) || !event.state().routingTable().equals(event.previousState().routingTable());
    }

    private void applyAliases(ClusterChangedEvent event) {
        if (this.aliasesChanged(event)) {
            for (IndexMetaData indexMetaData : event.state().metaData()) {
                if (!this.indicesService.hasIndex(indexMetaData.index())) continue;
                String index = indexMetaData.index();
                IndexService indexService = this.indicesService.indexService(index);
                IndexAliasesService indexAliasesService = indexService.aliasesService();
                this.processAliases(index, indexMetaData.aliases().values(), indexAliasesService);
                for (IndexAlias indexAlias : indexAliasesService) {
                    if (indexMetaData.aliases().containsKey(indexAlias.alias())) continue;
                    indexAliasesService.remove(indexAlias.alias());
                }
            }
        }
    }

    private void processAliases(String index, ObjectContainer<AliasMetaData> aliases, IndexAliasesService indexAliasesService) {
        HashMap<String, IndexAlias> newAliases = Maps.newHashMap();
        for (ObjectCursor<AliasMetaData> objectCursor : aliases) {
            AliasMetaData aliasMd = (AliasMetaData)objectCursor.value;
            String alias = aliasMd.alias();
            CompressedString filter2 = aliasMd.filter();
            try {
                if (!indexAliasesService.hasAlias(alias)) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("[{}] adding alias [{}], filter [{}]", index, alias, filter2);
                    }
                    newAliases.put(alias, indexAliasesService.create(alias, filter2));
                    continue;
                }
                if ((filter2 != null || indexAliasesService.alias(alias).filter() == null) && (filter2 == null || filter2.equals(indexAliasesService.alias(alias).filter()))) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("[{}] updating alias [{}], filter [{}]", index, alias, filter2);
                }
                newAliases.put(alias, indexAliasesService.create(alias, filter2));
            }
            catch (Throwable e) {
                this.logger.warn("[{}] failed to add alias [{}], filter [{}]", e, index, alias, filter2);
            }
        }
        indexAliasesService.addAll(newAliases);
    }

    private void applyNewOrUpdatedShards(ClusterChangedEvent event) throws ElasticSearchException {
        if (!this.indicesService.changesAllowed()) {
            return;
        }
        RoutingTable routingTable = event.state().routingTable();
        RoutingNodes.RoutingNodeIterator routingNode = event.state().readOnlyRoutingNodes().routingNodeIter(event.state().nodes().localNodeId());
        if (routingNode == null) {
            this.failedShards.clear();
            return;
        }
        DiscoveryNodes nodes = event.state().nodes();
        for (MutableShardRouting shardRouting : routingNode) {
            InternalIndexShard indexShard;
            ShardRouting currentRoutingEntry;
            IndexMetaData indexMetaData;
            IndexService indexService = this.indicesService.indexService(shardRouting.index());
            if (indexService == null || (indexMetaData = event.state().metaData().index(shardRouting.index())) == null) continue;
            int shardId = shardRouting.id();
            if (!indexService.hasShard(shardId) && shardRouting.started()) {
                if (this.failedShards.containsKey(shardRouting.shardId())) continue;
                this.logger.warn("[{}][{}] master [{}] marked shard as started, but shard has not been created, mark shard as failed", shardRouting.index(), shardId, nodes.masterNode());
                this.failedShards.put(shardRouting.shardId(), new FailedShard(shardRouting.version()));
                this.shardStateAction.shardFailed(shardRouting, indexMetaData.getUUID(), "master " + nodes.masterNode() + " marked shard as started, but shard has not been created, mark shard as failed");
                continue;
            }
            if (indexService.hasShard(shardId) && (currentRoutingEntry = (indexShard = (InternalIndexShard)indexService.shard(shardId)).routingEntry()).initializing() && shardRouting.initializing() && !currentRoutingEntry.equals(shardRouting)) {
                this.logger.debug("[{}][{}] removing shard (different instance of it allocated on this node, current [{}], global [{}])", shardRouting.index(), shardRouting.id(), currentRoutingEntry, shardRouting);
                this.recoveryTarget.cancelRecovery(indexShard);
                indexService.removeShard(shardRouting.id(), "removing shard (different instance of it allocated on this node)");
            }
            if (indexService.hasShard(shardId) && !((Object)shardRouting).equals((indexShard = (InternalIndexShard)indexService.shard(shardId)).routingEntry())) {
                indexShard.routingEntry(shardRouting);
                indexService.shardInjector(shardId).getInstance(IndexShardGatewayService.class).routingStateChanged();
            }
            if (!shardRouting.initializing()) continue;
            this.applyInitializingShard(routingTable, nodes, indexMetaData, routingTable.index(shardRouting.index()).shard(shardRouting.id()), shardRouting);
        }
    }

    private void cleanFailedShards(ClusterChangedEvent event) {
        RoutingTable routingTable = event.state().routingTable();
        RoutingNodes.RoutingNodeIterator routingNode = event.state().readOnlyRoutingNodes().routingNodeIter(event.state().nodes().localNodeId());
        if (routingNode == null) {
            this.failedShards.clear();
            return;
        }
        DiscoveryNodes nodes = event.state().nodes();
        long now = System.currentTimeMillis();
        String localNodeId = nodes.localNodeId();
        Iterator iterator2 = this.failedShards.entrySet().iterator();
        block0: while (iterator2.hasNext()) {
            IndexShardRoutingTable shardRoutingTable;
            Map.Entry entry2 = iterator2.next();
            FailedShard failedShard = (FailedShard)entry2.getValue();
            IndexRoutingTable indexRoutingTable = routingTable.index(((ShardId)entry2.getKey()).getIndex());
            if (indexRoutingTable != null && (shardRoutingTable = indexRoutingTable.shard(((ShardId)entry2.getKey()).id())) != null) {
                for (ShardRouting shardRouting : shardRoutingTable.assignedShards()) {
                    if (!localNodeId.equals(shardRouting.currentNodeId())) continue;
                    if (shardRouting.version() == failedShard.version && now - failedShard.timestamp < TimeValue.timeValueMinutes(60L).millis()) continue block0;
                }
            }
            iterator2.remove();
        }
    }

    private void applyInitializingShard(RoutingTable routingTable, DiscoveryNodes nodes, final IndexMetaData indexMetaData, IndexShardRoutingTable indexShardRouting, final ShardRouting shardRouting) throws ElasticSearchException {
        IndexShard indexShard;
        final IndexService indexService = this.indicesService.indexService(shardRouting.index());
        if (indexService == null) {
            return;
        }
        int shardId = shardRouting.id();
        if (indexService.hasShard(shardId)) {
            indexShard = indexService.shardSafe(shardId);
            if (indexShard.state() == IndexShardState.STARTED || indexShard.state() == IndexShardState.POST_RECOVERY) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("{} master marked shard as initializing, but shard has state [{}], resending shard started", new Object[]{indexShard.shardId(), indexShard.state()});
                }
                this.shardStateAction.shardStarted(shardRouting, indexMetaData.getUUID(), "master " + nodes.masterNode() + " marked shard as initializing, but shard state is [" + (Object)((Object)indexShard.state()) + "], mark shard as started");
                return;
            }
            if (indexShard.ignoreRecoveryAttempt()) {
                return;
            }
        }
        if (!indexService.hasShard(shardId)) {
            if (this.failedShards.containsKey(shardRouting.shardId())) {
                this.logger.trace("[{}][{}] not initializing, this shards failed to recover on this node before, waiting for reassignment", shardRouting.index(), shardRouting.id());
                return;
            }
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("[{}][{}] creating shard", shardRouting.index(), shardId);
                }
                indexShard = (InternalIndexShard)indexService.createShard(shardId);
                ((InternalIndexShard)indexShard).routingEntry(shardRouting);
                ((InternalIndexShard)indexShard).engine().addFailedEngineListener(this.failedEngineHandler);
            }
            catch (IndexShardAlreadyExistsException e) {
            }
            catch (Throwable e) {
                this.logger.warn("[{}][{}] failed to create shard", e, shardRouting.index(), shardRouting.id());
                try {
                    indexService.removeShard(shardId, "failed to create [" + ExceptionsHelper.detailedMessage(e) + "]");
                }
                catch (IndexShardMissingException e1) {
                }
                catch (Throwable e1) {
                    this.logger.warn("[{}][{}] failed to remove shard after failed creation", e1, shardRouting.index(), shardRouting.id());
                }
                this.failedShards.put(shardRouting.shardId(), new FailedShard(shardRouting.version()));
                this.shardStateAction.shardFailed(shardRouting, indexMetaData.getUUID(), "Failed to create shard, message [" + ExceptionsHelper.detailedMessage(e) + "]");
                return;
            }
        }
        if (((InternalIndexShard)(indexShard = (InternalIndexShard)indexService.shardSafe(shardId))).ignoreRecoveryAttempt()) {
            return;
        }
        if (!shardRouting.primary()) {
            IndexShardRoutingTable shardRoutingTable = routingTable.index(shardRouting.index()).shard(shardRouting.id());
            for (ShardRouting entry2 : shardRoutingTable) {
                if (!entry2.primary() || !entry2.started()) continue;
                DiscoveryNode sourceNode = nodes.get(entry2.currentNodeId());
                try {
                    StartRecoveryRequest request = new StartRecoveryRequest(((AbstractIndexShardComponent)((Object)indexShard)).shardId(), sourceNode, nodes.localNode(), false, ((InternalIndexShard)indexShard).store().list());
                    this.recoveryTarget.startRecovery(request, (InternalIndexShard)indexShard, new PeerRecoveryListener(request, shardRouting, indexService, indexMetaData));
                }
                catch (Throwable e) {
                    this.handleRecoveryFailure(indexService, indexMetaData, shardRouting, true, e);
                }
                break;
            }
        } else if (shardRouting.relocatingNodeId() == null) {
            boolean indexShouldExists = indexShardRouting.primaryAllocatedPostApi();
            IndexShardGatewayService shardGatewayService = indexService.shardInjector(shardId).getInstance(IndexShardGatewayService.class);
            shardGatewayService.recover(indexShouldExists, new IndexShardGatewayService.RecoveryListener(){

                @Override
                public void onRecoveryDone() {
                    IndicesClusterStateService.this.shardStateAction.shardStarted(shardRouting, indexMetaData.getUUID(), "after recovery from gateway");
                }

                @Override
                public void onIgnoreRecovery(String reason) {
                }

                @Override
                public void onRecoveryFailed(IndexShardGatewayRecoveryException e) {
                    IndicesClusterStateService.this.handleRecoveryFailure(indexService, indexMetaData, shardRouting, true, e);
                }
            });
        } else {
            DiscoveryNode sourceNode = nodes.get(shardRouting.relocatingNodeId());
            try {
                StartRecoveryRequest request = new StartRecoveryRequest(((AbstractIndexShardComponent)((Object)indexShard)).shardId(), sourceNode, nodes.localNode(), false, ((InternalIndexShard)indexShard).store().list());
                this.recoveryTarget.startRecovery(request, (InternalIndexShard)indexShard, new PeerRecoveryListener(request, shardRouting, indexService, indexMetaData));
            }
            catch (Throwable e) {
                this.handleRecoveryFailure(indexService, indexMetaData, shardRouting, true, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRecoveryFailure(IndexService indexService, IndexMetaData indexMetaData, ShardRouting shardRouting, boolean sendShardFailure, Throwable failure2) {
        this.logger.warn("[{}][{}] failed to start shard", failure2, indexService.index().name(), shardRouting.shardId().id());
        Object object = this.mutex;
        synchronized (object) {
            if (indexService.hasShard(shardRouting.shardId().id())) {
                try {
                    indexService.removeShard(shardRouting.shardId().id(), "recovery failure [" + ExceptionsHelper.detailedMessage(failure2) + "]");
                }
                catch (IndexShardMissingException e) {
                }
                catch (Throwable e1) {
                    this.logger.warn("[{}][{}] failed to delete shard after failed startup", e1, indexService.index().name(), shardRouting.shardId().id());
                }
            }
            if (sendShardFailure) {
                try {
                    this.failedShards.put(shardRouting.shardId(), new FailedShard(shardRouting.version()));
                    this.shardStateAction.shardFailed(shardRouting, indexMetaData.getUUID(), "Failed to start shard, message [" + ExceptionsHelper.detailedMessage(failure2) + "]");
                }
                catch (Throwable e1) {
                    this.logger.warn("[{}][{}] failed to mark shard as failed after a failed start", e1, indexService.index().name(), shardRouting.id());
                }
            }
        }
    }

    private void removeIndex(String index, String reason) {
        try {
            this.indicesService.removeIndex(index, reason);
        }
        catch (Throwable e) {
            this.logger.warn("failed to clean index ({})", e, reason);
        }
        for (Tuple tuple : this.seenMappings.keySet()) {
            if (!((String)tuple.v1()).equals(index)) continue;
            this.seenMappings.remove(tuple);
        }
    }

    private class FailedEngineHandler
    implements Engine.FailedEngineListener {
        private FailedEngineHandler() {
        }

        @Override
        public void onFailedEngine(final ShardId shardId, final Throwable failure2) {
            IndexShard indexShard;
            ShardRouting shardRouting = null;
            final IndexService indexService = IndicesClusterStateService.this.indicesService.indexService(shardId.index().name());
            if (indexService != null && (indexShard = indexService.shard(shardId.id())) != null) {
                shardRouting = indexShard.routingEntry();
            }
            if (shardRouting == null) {
                IndicesClusterStateService.this.logger.warn("[{}][{}] engine failed, but can't find index shard", shardId.index().name(), shardId.id());
                return;
            }
            final ShardRouting fShardRouting = shardRouting;
            final String indexUUID = indexService.indexUUID();
            IndicesClusterStateService.this.threadPool.generic().execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = IndicesClusterStateService.this.mutex;
                    synchronized (object) {
                        if (indexService.hasShard(shardId.id())) {
                            try {
                                indexService.removeShard(shardId.id(), "engine failure [" + ExceptionsHelper.detailedMessage(failure2) + "]");
                            }
                            catch (IndexShardMissingException e) {
                            }
                            catch (Throwable e1) {
                                IndicesClusterStateService.this.logger.warn("[{}][{}] failed to delete shard after failed engine", e1, indexService.index().name(), shardId.id());
                            }
                        }
                        try {
                            IndicesClusterStateService.this.failedShards.put(fShardRouting.shardId(), new FailedShard(fShardRouting.version()));
                            IndicesClusterStateService.this.shardStateAction.shardFailed(fShardRouting, indexUUID, "engine failure, message [" + ExceptionsHelper.detailedMessage(failure2) + "]");
                        }
                        catch (Throwable e1) {
                            IndicesClusterStateService.this.logger.warn("[{}][{}] failed to mark shard as failed after a failed engine", e1, indexService.index().name(), shardId.id());
                        }
                    }
                }
            });
        }
    }

    private class PeerRecoveryListener
    implements RecoveryTarget.RecoveryListener {
        private final StartRecoveryRequest request;
        private final ShardRouting shardRouting;
        private final IndexService indexService;
        private final IndexMetaData indexMetaData;

        private PeerRecoveryListener(StartRecoveryRequest request, ShardRouting shardRouting, IndexService indexService, IndexMetaData indexMetaData) {
            this.request = request;
            this.shardRouting = shardRouting;
            this.indexService = indexService;
            this.indexMetaData = indexMetaData;
        }

        @Override
        public void onRecoveryDone() {
            IndicesClusterStateService.this.shardStateAction.shardStarted(this.shardRouting, this.indexMetaData.getUUID(), "after recovery (replica) from node [" + this.request.sourceNode() + "]");
        }

        @Override
        public void onRetryRecovery(TimeValue retryAfter, RecoveryStatus recoveryStatus) {
            IndicesClusterStateService.this.recoveryTarget.retryRecovery(this.request, recoveryStatus, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onIgnoreRecovery(boolean removeShard, String reason) {
            if (!removeShard) {
                return;
            }
            Object object = IndicesClusterStateService.this.mutex;
            synchronized (object) {
                if (this.indexService.hasShard(this.shardRouting.shardId().id())) {
                    if (IndicesClusterStateService.this.logger.isDebugEnabled()) {
                        IndicesClusterStateService.this.logger.debug("[{}][{}] removing shard on ignored recovery, reason [{}]", this.shardRouting.index(), this.shardRouting.shardId().id(), reason);
                    }
                    try {
                        this.indexService.removeShard(this.shardRouting.shardId().id(), "ignore recovery: " + reason);
                    }
                    catch (IndexShardMissingException e) {
                    }
                    catch (Throwable e1) {
                        IndicesClusterStateService.this.logger.warn("[{}][{}] failed to delete shard after ignore recovery", e1, this.indexService.index().name(), this.shardRouting.shardId().id());
                    }
                }
            }
        }

        @Override
        public void onRecoveryFailure(RecoveryFailedException e, boolean sendShardFailure) {
            IndicesClusterStateService.this.handleRecoveryFailure(this.indexService, this.indexMetaData, this.shardRouting, sendShardFailure, e);
        }
    }

    static class FailedShard {
        public final long version;
        public final long timestamp;

        FailedShard(long version) {
            this.version = version;
            this.timestamp = System.currentTimeMillis();
        }
    }
}

