/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.cache.filter;

import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.search.DocIdSet;
import org.elasticsearch.cache.recycler.CacheRecycler;
import org.elasticsearch.common.base.Objects;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.cache.RemovalListener;
import org.elasticsearch.common.cache.RemovalNotification;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.index.cache.filter.weighted.WeightedFilterCache;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.node.settings.NodeSettingsService;
import org.elasticsearch.threadpool.ThreadPool;

public class IndicesFilterCache
extends AbstractComponent
implements RemovalListener<WeightedFilterCache.FilterCacheKey, DocIdSet> {
    private final ThreadPool threadPool;
    private final CacheRecycler cacheRecycler;
    private Cache<WeightedFilterCache.FilterCacheKey, DocIdSet> cache;
    private volatile String size;
    private volatile long sizeInBytes;
    private volatile TimeValue expire;
    private final TimeValue cleanInterval;
    private final Set<Object> readersKeysToClean = ConcurrentCollections.newConcurrentSet();
    private volatile boolean closed;
    public static final String INDICES_CACHE_FILTER_SIZE = "indices.cache.filter.size";
    public static final String INDICES_CACHE_FILTER_EXPIRE = "indices.cache.filter.expire";

    @Inject
    public IndicesFilterCache(Settings settings, ThreadPool threadPool, CacheRecycler cacheRecycler, NodeSettingsService nodeSettingsService) {
        super(settings);
        this.threadPool = threadPool;
        this.cacheRecycler = cacheRecycler;
        this.size = this.componentSettings.get("size", "20%");
        this.expire = this.componentSettings.getAsTime("expire", null);
        this.cleanInterval = this.componentSettings.getAsTime("clean_interval", TimeValue.timeValueSeconds(60L));
        this.computeSizeInBytes();
        this.buildCache();
        this.logger.debug("using [node] weighted filter cache with size [{}], actual_size [{}], expire [{}], clean_interval [{}]", this.size, new ByteSizeValue(this.sizeInBytes), this.expire, this.cleanInterval);
        nodeSettingsService.addListener(new ApplySettings());
        threadPool.schedule(this.cleanInterval, "same", new ReaderCleaner());
    }

    private void buildCache() {
        CacheBuilder<WeightedFilterCache.FilterCacheKey, DocIdSet> cacheBuilder = CacheBuilder.newBuilder().removalListener(this).maximumWeight(this.sizeInBytes).weigher(new WeightedFilterCache.FilterCacheValueWeigher());
        cacheBuilder.concurrencyLevel(16);
        if (this.expire != null) {
            cacheBuilder.expireAfterAccess(this.expire.millis(), TimeUnit.MILLISECONDS);
        }
        this.cache = cacheBuilder.build();
    }

    private void computeSizeInBytes() {
        if (this.size.endsWith("%")) {
            double percent2 = Double.parseDouble(this.size.substring(0, this.size.length() - 1));
            this.sizeInBytes = (long)(percent2 / 100.0 * (double)JvmInfo.jvmInfo().getMem().getHeapMax().bytes());
        } else {
            this.sizeInBytes = ByteSizeValue.parseBytesSizeValue(this.size).bytes();
        }
    }

    public void addReaderKeyToClean(Object readerKey) {
        this.readersKeysToClean.add(readerKey);
    }

    public void close() {
        this.closed = true;
        this.cache.invalidateAll();
    }

    public Cache<WeightedFilterCache.FilterCacheKey, DocIdSet> cache() {
        return this.cache;
    }

    @Override
    public void onRemoval(RemovalNotification<WeightedFilterCache.FilterCacheKey, DocIdSet> removalNotification) {
        WeightedFilterCache.FilterCacheKey key = removalNotification.getKey();
        if (key == null) {
            return;
        }
        if (key.removalListener != null) {
            key.removalListener.onRemoval(removalNotification);
        }
    }

    class ReaderCleaner
    implements Runnable {
        ReaderCleaner() {
        }

        @Override
        public void run() {
            if (IndicesFilterCache.this.closed) {
                return;
            }
            if (IndicesFilterCache.this.readersKeysToClean.isEmpty()) {
                this.schedule();
                return;
            }
            try {
                IndicesFilterCache.this.threadPool.executor("generic").execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Recycler.V keys = IndicesFilterCache.this.cacheRecycler.hashSet(-1);
                        try {
                            Iterator<Object> it = IndicesFilterCache.this.readersKeysToClean.iterator();
                            while (it.hasNext()) {
                                keys.v().add(it.next());
                                it.remove();
                            }
                            IndicesFilterCache.this.cache.cleanUp();
                            if (!keys.v().isEmpty()) {
                                it = IndicesFilterCache.this.cache.asMap().keySet().iterator();
                                while (it.hasNext()) {
                                    WeightedFilterCache.FilterCacheKey filterCacheKey = (WeightedFilterCache.FilterCacheKey)it.next();
                                    if (!keys.v().contains(filterCacheKey.readerKey())) continue;
                                    it.remove();
                                }
                            }
                            ReaderCleaner.this.schedule();
                        }
                        finally {
                            keys.release();
                        }
                    }
                });
            }
            catch (EsRejectedExecutionException ex) {
                IndicesFilterCache.this.logger.debug("Can not run ReaderCleaner - execution rejected", ex, new Object[0]);
            }
        }

        private void schedule() {
            try {
                IndicesFilterCache.this.threadPool.schedule(IndicesFilterCache.this.cleanInterval, "same", this);
            }
            catch (EsRejectedExecutionException ex) {
                IndicesFilterCache.this.logger.debug("Can not schedule ReaderCleaner - execution rejected", ex, new Object[0]);
            }
        }
    }

    class ApplySettings
    implements NodeSettingsService.Listener {
        ApplySettings() {
        }

        @Override
        public void onRefreshSettings(Settings settings) {
            TimeValue expire2;
            boolean replace = false;
            String size2 = settings.get(IndicesFilterCache.INDICES_CACHE_FILTER_SIZE, IndicesFilterCache.this.size);
            if (!size2.equals(IndicesFilterCache.this.size)) {
                IndicesFilterCache.this.logger.info("updating [indices.cache.filter.size] from [{}] to [{}]", IndicesFilterCache.this.size, size2);
                IndicesFilterCache.this.size = size2;
                replace = true;
            }
            if (!Objects.equal(expire2 = settings.getAsTime(IndicesFilterCache.INDICES_CACHE_FILTER_EXPIRE, IndicesFilterCache.this.expire), IndicesFilterCache.this.expire)) {
                IndicesFilterCache.this.logger.info("updating [indices.cache.filter.expire] from [{}] to [{}]", IndicesFilterCache.this.expire, expire2);
                IndicesFilterCache.this.expire = expire2;
                replace = true;
            }
            if (replace) {
                Cache oldCache = IndicesFilterCache.this.cache;
                IndicesFilterCache.this.computeSizeInBytes();
                IndicesFilterCache.this.buildCache();
                oldCache.invalidateAll();
            }
        }
    }
}

