/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.analysis;

import java.io.Reader;
import java.util.Locale;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.core.LetterTokenizer;
import org.apache.lucene.analysis.core.LowerCaseTokenizer;
import org.apache.lucene.analysis.core.WhitespaceTokenizer;
import org.apache.lucene.analysis.ngram.EdgeNGramTokenizer;
import org.apache.lucene.analysis.ngram.NGramTokenizer;
import org.apache.lucene.analysis.path.PathHierarchyTokenizer;
import org.apache.lucene.analysis.pattern.PatternTokenizer;
import org.apache.lucene.analysis.standard.ClassicTokenizer;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.analysis.standard.UAX29URLEmailTokenizer;
import org.elasticsearch.Version;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.index.analysis.TokenizerFactory;
import org.elasticsearch.indices.analysis.PreBuiltCacheFactory;

public enum PreBuiltTokenizers {
    STANDARD(PreBuiltCacheFactory.CachingStrategy.LUCENE){

        @Override
        protected Tokenizer create(Reader reader, Version version) {
            return new StandardTokenizer(version.luceneVersion, reader);
        }
    }
    ,
    CLASSIC(PreBuiltCacheFactory.CachingStrategy.LUCENE){

        @Override
        protected Tokenizer create(Reader reader, Version version) {
            return new ClassicTokenizer(version.luceneVersion, reader);
        }
    }
    ,
    UAX_URL_EMAIL(PreBuiltCacheFactory.CachingStrategy.LUCENE){

        @Override
        protected Tokenizer create(Reader reader, Version version) {
            return new UAX29URLEmailTokenizer(version.luceneVersion, reader);
        }
    }
    ,
    PATH_HIERARCHY(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        protected Tokenizer create(Reader reader, Version version) {
            return new PathHierarchyTokenizer(reader);
        }
    }
    ,
    KEYWORD(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        protected Tokenizer create(Reader reader, Version version) {
            return new KeywordTokenizer(reader);
        }
    }
    ,
    LETTER(PreBuiltCacheFactory.CachingStrategy.LUCENE){

        @Override
        protected Tokenizer create(Reader reader, Version version) {
            return new LetterTokenizer(version.luceneVersion, reader);
        }
    }
    ,
    LOWERCASE(PreBuiltCacheFactory.CachingStrategy.LUCENE){

        @Override
        protected Tokenizer create(Reader reader, Version version) {
            return new LowerCaseTokenizer(version.luceneVersion, reader);
        }
    }
    ,
    WHITESPACE(PreBuiltCacheFactory.CachingStrategy.LUCENE){

        @Override
        protected Tokenizer create(Reader reader, Version version) {
            return new WhitespaceTokenizer(version.luceneVersion, reader);
        }
    }
    ,
    NGRAM(PreBuiltCacheFactory.CachingStrategy.LUCENE){

        @Override
        protected Tokenizer create(Reader reader, Version version) {
            return new NGramTokenizer(version.luceneVersion, reader);
        }
    }
    ,
    EDGE_NGRAM(PreBuiltCacheFactory.CachingStrategy.LUCENE){

        @Override
        protected Tokenizer create(Reader reader, Version version) {
            return new EdgeNGramTokenizer(version.luceneVersion, reader, 1, 1);
        }
    }
    ,
    PATTERN(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        protected Tokenizer create(Reader reader, Version version) {
            return new PatternTokenizer(reader, Regex.compile("\\W+", null), -1);
        }
    };

    protected final PreBuiltCacheFactory.PreBuiltCache<TokenizerFactory> cache;

    protected abstract Tokenizer create(Reader var1, Version var2);

    private PreBuiltTokenizers(PreBuiltCacheFactory.CachingStrategy cachingStrategy) {
        this.cache = PreBuiltCacheFactory.getCache(cachingStrategy);
    }

    public synchronized TokenizerFactory getTokenizerFactory(final Version version) {
        TokenizerFactory tokenizerFactory = this.cache.get(version);
        if (tokenizerFactory == null) {
            final String finalName = this.name();
            tokenizerFactory = new TokenizerFactory(){

                @Override
                public String name() {
                    return finalName.toLowerCase(Locale.ROOT);
                }

                @Override
                public Tokenizer create(Reader reader) {
                    return PreBuiltTokenizers.valueOf(finalName).create(reader, version);
                }
            };
            this.cache.put(version, tokenizerFactory);
        }
        return tokenizerFactory;
    }
}

