/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.analysis;

import java.util.Map;
import org.apache.lucene.analysis.hunspell.HunspellDictionary;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.multibindings.MapBinder;
import org.elasticsearch.indices.analysis.HunspellService;
import org.elasticsearch.indices.analysis.IndicesAnalysisService;

public class IndicesAnalysisModule
extends AbstractModule {
    private final Map<String, HunspellDictionary> hunspellDictionaries = Maps.newHashMap();

    public void addHunspellDictionary(String lang, HunspellDictionary dictionary) {
        this.hunspellDictionaries.put(lang, dictionary);
    }

    @Override
    protected void configure() {
        this.bind(IndicesAnalysisService.class).asEagerSingleton();
        MapBinder<String, HunspellDictionary> dictionariesBinder = MapBinder.newMapBinder(this.binder(), String.class, HunspellDictionary.class);
        for (Map.Entry<String, HunspellDictionary> entry2 : this.hunspellDictionaries.entrySet()) {
            dictionariesBinder.addBinding(entry2.getKey()).toInstance(entry2.getValue());
        }
        this.bind(HunspellService.class).asEagerSingleton();
    }
}

