/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.analysis;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.analysis.hunspell.HunspellDictionary;
import org.apache.lucene.util.Version;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.cache.CacheLoader;
import org.elasticsearch.common.cache.LoadingCache;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;

public class HunspellService
extends AbstractComponent {
    private static final DictionaryFileFilter DIC_FILE_FILTER = new DictionaryFileFilter();
    private static final AffixFileFilter AFFIX_FILE_FILTER = new AffixFileFilter();
    private final LoadingCache<String, HunspellDictionary> dictionaries;
    private final Map<String, HunspellDictionary> knownDictionaries;
    private final boolean defaultIgnoreCase;
    private final boolean defaultStrictAffixParsing;
    private final File hunspellDir;

    public HunspellService(Settings settings, Environment env) {
        this(settings, env, Collections.emptyMap());
    }

    @Inject
    public HunspellService(final Settings settings, final Environment env, final Map<String, HunspellDictionary> knownDictionaries) {
        super(settings);
        this.knownDictionaries = knownDictionaries;
        this.hunspellDir = this.resolveHunspellDirectory(settings, env);
        this.defaultIgnoreCase = settings.getAsBoolean("indices.analysis.hunspell.dictionary.ignore_case", (Boolean)false);
        this.defaultStrictAffixParsing = settings.getAsBoolean("indices.analysis.hunspell.dictionary.strict_affix_parsing", (Boolean)false);
        final Version version = Lucene.parseVersion(settings.get("indices.analysis.hunspell.version"), Lucene.ANALYZER_VERSION, this.logger);
        this.dictionaries = CacheBuilder.newBuilder().build(new CacheLoader<String, HunspellDictionary>(){

            @Override
            public HunspellDictionary load(String locale) throws Exception {
                HunspellDictionary dictionary = (HunspellDictionary)knownDictionaries.get(locale);
                if (dictionary == null) {
                    dictionary = HunspellService.this.loadDictionary(locale, settings, env, version);
                }
                return dictionary;
            }
        });
        this.scanAndLoadDictionaries();
    }

    public HunspellDictionary getDictionary(String locale) {
        return this.dictionaries.getUnchecked(locale);
    }

    private File resolveHunspellDirectory(Settings settings, Environment env) {
        String location = settings.get("indices.analysis.hunspell.dictionary.location", null);
        if (location != null) {
            return new File(location);
        }
        return new File(env.configFile(), "hunspell");
    }

    private void scanAndLoadDictionaries() {
        if (this.hunspellDir.exists() && this.hunspellDir.isDirectory()) {
            for (File file : this.hunspellDir.listFiles()) {
                if (!file.isDirectory() || file.list(AFFIX_FILE_FILTER).length <= 0) continue;
                this.dictionaries.getUnchecked(file.getName());
            }
        }
    }

    private HunspellDictionary loadDictionary(String locale, Settings nodeSettings, Environment env, Version version) throws Exception {
        File dicDir;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Loading huspell dictionary [{}]...", locale);
        }
        if (!(dicDir = new File(this.hunspellDir, locale)).exists() || !dicDir.isDirectory()) {
            throw new ElasticSearchException(String.format(Locale.ROOT, "Could not find hunspell dictionary [%s]", locale));
        }
        nodeSettings = HunspellService.loadDictionarySettings(dicDir, nodeSettings.getByPrefix("indices.analysis.hunspell.dictionary." + locale + "."));
        boolean ignoreCase = nodeSettings.getAsBoolean("ignore_case", (Boolean)this.defaultIgnoreCase);
        boolean strictAffixParsing = nodeSettings.getAsBoolean("strict_affix_parsing", (Boolean)this.defaultStrictAffixParsing);
        File[] affixFiles = dicDir.listFiles(AFFIX_FILE_FILTER);
        if (affixFiles.length != 1) {
            throw new ElasticSearchException(String.format(Locale.ROOT, "Missing affix file for hunspell dictionary [%s]", locale));
        }
        InputStream affixStream = null;
        File[] dicFiles = dicDir.listFiles(DIC_FILE_FILTER);
        ArrayList<InputStream> dicStreams = new ArrayList<InputStream>(dicFiles.length);
        try {
            for (int i = 0; i < dicFiles.length; ++i) {
                dicStreams.add(new FileInputStream(dicFiles[i]));
            }
            affixStream = new FileInputStream(affixFiles[0]);
            HunspellDictionary i = new HunspellDictionary(affixStream, dicStreams, version, ignoreCase, strictAffixParsing);
            return i;
        }
        catch (Exception e) {
            this.logger.error("Could not load hunspell dictionary [{}]", e, locale);
            throw e;
        }
        finally {
            if (affixStream != null) {
                try {
                    affixStream.close();
                }
                catch (IOException e) {}
            }
            for (InputStream in : dicStreams) {
                if (in == null) continue;
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private static Settings loadDictionarySettings(File dir, Settings defaults) {
        File file = new File(dir, "settings.yml");
        if (file.exists()) {
            try {
                return ImmutableSettings.settingsBuilder().loadFromUrl(file.toURI().toURL()).put(defaults).build();
            }
            catch (MalformedURLException e) {
                throw new ElasticSearchException(String.format(Locale.ROOT, "Could not load hunspell dictionary settings from [%s]", file.getAbsolutePath()), e);
            }
        }
        file = new File(dir, "settings.json");
        if (file.exists()) {
            try {
                return ImmutableSettings.settingsBuilder().loadFromUrl(file.toURI().toURL()).put(defaults).build();
            }
            catch (MalformedURLException e) {
                throw new ElasticSearchException(String.format(Locale.ROOT, "Could not load hunspell dictionary settings from [%s]", file.getAbsolutePath()), e);
            }
        }
        return defaults;
    }

    static class AffixFileFilter
    implements FilenameFilter {
        AffixFileFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.toLowerCase(Locale.ROOT).endsWith(".aff");
        }
    }

    static class DictionaryFileFilter
    implements FilenameFilter {
        DictionaryFileFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.toLowerCase(Locale.ROOT).endsWith(".dic");
        }
    }
}

