/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices;

import java.util.concurrent.CopyOnWriteArrayList;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.indices.IndicesLifecycle;

public class InternalIndicesLifecycle
extends AbstractComponent
implements IndicesLifecycle {
    private final CopyOnWriteArrayList<IndicesLifecycle.Listener> listeners = new CopyOnWriteArrayList();

    @Inject
    public InternalIndicesLifecycle(Settings settings) {
        super(settings);
    }

    @Override
    public void addListener(IndicesLifecycle.Listener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(IndicesLifecycle.Listener listener) {
        this.listeners.remove(listener);
    }

    public void shardRoutingChanged(IndexShard indexShard, @Nullable ShardRouting oldRouting, ShardRouting newRouting) {
        for (IndicesLifecycle.Listener listener : this.listeners) {
            try {
                listener.shardRoutingChanged(indexShard, oldRouting, newRouting);
            }
            catch (Throwable t) {
                this.logger.warn("{} failed to invoke shard touring changed callback", t, indexShard.shardId());
            }
        }
    }

    public void beforeIndexCreated(Index index) {
        for (IndicesLifecycle.Listener listener : this.listeners) {
            try {
                listener.beforeIndexCreated(index);
            }
            catch (Throwable t) {
                this.logger.warn("[{}] failed to invoke before index created callback", t, index.name());
            }
        }
    }

    public void afterIndexCreated(IndexService indexService) {
        for (IndicesLifecycle.Listener listener : this.listeners) {
            try {
                listener.afterIndexCreated(indexService);
            }
            catch (Throwable t) {
                this.logger.warn("[{}] failed to invoke after index created callback", t, indexService.index().name());
            }
        }
    }

    public void beforeIndexShardCreated(ShardId shardId) {
        for (IndicesLifecycle.Listener listener : this.listeners) {
            try {
                listener.beforeIndexShardCreated(shardId);
            }
            catch (Throwable t) {
                this.logger.warn("{} failed to invoke before shard created callback", t, shardId);
            }
        }
    }

    public void afterIndexShardCreated(IndexShard indexShard) {
        for (IndicesLifecycle.Listener listener : this.listeners) {
            try {
                listener.afterIndexShardCreated(indexShard);
            }
            catch (Throwable t) {
                this.logger.warn("{} failed to invoke after shard created callback", t, indexShard.shardId());
            }
        }
    }

    public void afterIndexShardStarted(IndexShard indexShard) {
        for (IndicesLifecycle.Listener listener : this.listeners) {
            try {
                listener.afterIndexShardStarted(indexShard);
            }
            catch (Throwable t) {
                this.logger.warn("{} failed to invoke after shard started callback", t, indexShard.shardId());
            }
        }
    }

    public void beforeIndexClosed(IndexService indexService) {
        for (IndicesLifecycle.Listener listener : this.listeners) {
            try {
                listener.beforeIndexClosed(indexService);
            }
            catch (Throwable t) {
                this.logger.warn("[{}] failed to invoke before index closed callback", t, indexService.index().name());
            }
        }
    }

    public void afterIndexClosed(Index index) {
        for (IndicesLifecycle.Listener listener : this.listeners) {
            try {
                listener.afterIndexClosed(index);
            }
            catch (Throwable t) {
                this.logger.warn("[{}] failed to invoke after index closed callback", t, index.name());
            }
        }
    }

    public void beforeIndexShardClosed(ShardId shardId, @Nullable IndexShard indexShard) {
        for (IndicesLifecycle.Listener listener : this.listeners) {
            try {
                listener.beforeIndexShardClosed(shardId, indexShard);
            }
            catch (Throwable t) {
                this.logger.warn("{} failed to invoke before shard closed callback", t, shardId);
            }
        }
    }

    public void afterIndexShardClosed(ShardId shardId) {
        for (IndicesLifecycle.Listener listener : this.listeners) {
            try {
                listener.afterIndexShardClosed(shardId);
            }
            catch (Throwable t) {
                this.logger.warn("{} failed to invoke after shard closed callback", t, shardId);
            }
        }
    }

    public void indexShardStateChanged(IndexShard indexShard, @Nullable IndexShardState previousState, @Nullable String reason) {
        for (IndicesLifecycle.Listener listener : this.listeners) {
            try {
                listener.indexShardStateChanged(indexShard, previousState, indexShard.state(), reason);
            }
            catch (Throwable t) {
                this.logger.warn("{} failed to invoke index shard state changed callback", t, indexShard.shardId());
            }
        }
    }
}

