/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices;

import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.service.IndexShard;

public interface IndicesLifecycle {
    public void addListener(Listener var1);

    public void removeListener(Listener var1);

    public static abstract class Listener {
        public void shardRoutingChanged(IndexShard indexShard, @Nullable ShardRouting oldRouting, ShardRouting newRouting) {
        }

        public void beforeIndexCreated(Index index) {
        }

        public void afterIndexCreated(IndexService indexService) {
        }

        public void beforeIndexShardCreated(ShardId shardId) {
        }

        public void afterIndexShardCreated(IndexShard indexShard) {
        }

        public void afterIndexShardStarted(IndexShard indexShard) {
        }

        public void beforeIndexClosed(IndexService indexService) {
        }

        public void afterIndexClosed(Index index) {
        }

        public void beforeIndexShardClosed(ShardId shardId, @Nullable IndexShard indexShard) {
        }

        public void afterIndexShardClosed(ShardId shardId) {
        }

        public void indexShardStateChanged(IndexShard indexShard, @Nullable IndexShardState previousState, IndexShardState currentState, @Nullable String reason) {
        }
    }
}

