/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.translog.fs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.concurrent.atomic.AtomicInteger;

public class RafReference {
    private final File file;
    private final RandomAccessFile raf;
    private final FileChannel channel;
    private final AtomicInteger refCount = new AtomicInteger();

    public RafReference(File file) throws FileNotFoundException {
        this.file = file;
        this.raf = new RandomAccessFile(file, "rw");
        this.channel = this.raf.getChannel();
        this.refCount.incrementAndGet();
    }

    public File file() {
        return this.file;
    }

    public FileChannel channel() {
        return this.channel;
    }

    public RandomAccessFile raf() {
        return this.raf;
    }

    public boolean increaseRefCount() {
        return this.refCount.incrementAndGet() > 1;
    }

    public void decreaseRefCount(boolean delete2) {
        if (this.refCount.decrementAndGet() <= 0) {
            try {
                this.raf.close();
                if (delete2) {
                    this.file.delete();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

