/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store.ram;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.store.RAMFile;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.DirectoryService;
import org.elasticsearch.index.store.DirectoryUtils;

public final class RamDirectoryService
extends AbstractIndexShardComponent
implements DirectoryService {
    @Inject
    public RamDirectoryService(ShardId shardId, @IndexSettings Settings indexSettings) {
        super(shardId, indexSettings);
    }

    @Override
    public long throttleTimeInNanos() {
        return 0L;
    }

    @Override
    public Directory[] build() {
        return new Directory[]{new CustomRAMDirectory()};
    }

    @Override
    public void renameFile(Directory dir, String from2, String to2) throws IOException {
        CustomRAMDirectory leaf = DirectoryUtils.getLeaf(dir, CustomRAMDirectory.class);
        assert (leaf != null);
        leaf.renameTo(from2, to2);
    }

    @Override
    public void fullDelete(Directory dir) {
    }

    static class CustomRAMDirectory
    extends RAMDirectory {
        CustomRAMDirectory() {
        }

        public synchronized void renameTo(String from2, String to2) throws IOException {
            RAMFile fromFile2 = (RAMFile)this.fileMap.get(from2);
            if (fromFile2 == null) {
                throw new FileNotFoundException(from2);
            }
            RAMFile toFile = (RAMFile)this.fileMap.get(to2);
            if (toFile != null) {
                this.sizeInBytes.addAndGet(-this.fileLength(from2));
                this.fileMap.remove(from2);
            }
            this.fileMap.put(to2, fromFile2);
        }
    }
}

