/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store.memory;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.bytebuffer.ByteBufferAllocator;
import org.apache.lucene.store.bytebuffer.ByteBufferDirectory;
import org.apache.lucene.store.bytebuffer.ByteBufferFile;
import org.elasticsearch.cache.memory.ByteBufferCache;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.DirectoryService;
import org.elasticsearch.index.store.DirectoryUtils;

public final class ByteBufferDirectoryService
extends AbstractIndexShardComponent
implements DirectoryService {
    private final ByteBufferCache byteBufferCache;

    @Inject
    public ByteBufferDirectoryService(ShardId shardId, @IndexSettings Settings indexSettings, ByteBufferCache byteBufferCache) {
        super(shardId, indexSettings);
        this.byteBufferCache = byteBufferCache;
    }

    @Override
    public long throttleTimeInNanos() {
        return 0L;
    }

    @Override
    public Directory[] build() {
        return new Directory[]{new CustomByteBufferDirectory(this.byteBufferCache)};
    }

    @Override
    public void renameFile(Directory dir, String from2, String to2) throws IOException {
        CustomByteBufferDirectory leaf = DirectoryUtils.getLeaf(dir, CustomByteBufferDirectory.class);
        assert (leaf != null);
        leaf.renameTo(from2, to2);
    }

    @Override
    public void fullDelete(Directory dir) {
    }

    static class CustomByteBufferDirectory
    extends ByteBufferDirectory {
        CustomByteBufferDirectory() {
        }

        CustomByteBufferDirectory(ByteBufferAllocator allocator) {
            super(allocator);
        }

        public void renameTo(String from2, String to2) throws IOException {
            ByteBufferFile fromFile2 = (ByteBufferFile)this.files.get(from2);
            if (fromFile2 == null) {
                throw new FileNotFoundException(from2);
            }
            ByteBufferFile toFile = (ByteBufferFile)this.files.get(to2);
            if (toFile != null) {
                this.files.remove(from2);
            }
            this.files.put(to2, fromFile2);
        }
    }
}

