/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store.fs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NativeFSLockFactory;
import org.apache.lucene.store.NoLockFactory;
import org.apache.lucene.store.RateLimitedFSDirectory;
import org.apache.lucene.store.SimpleFSLockFactory;
import org.apache.lucene.store.StoreRateLimiting;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.DirectoryService;
import org.elasticsearch.index.store.DirectoryUtils;
import org.elasticsearch.index.store.IndexStore;
import org.elasticsearch.index.store.fs.FsIndexStore;

public abstract class FsDirectoryService
extends AbstractIndexShardComponent
implements DirectoryService,
StoreRateLimiting.Listener,
StoreRateLimiting.Provider {
    protected final FsIndexStore indexStore;
    private final CounterMetric rateLimitingTimeInNanos = new CounterMetric();

    public FsDirectoryService(ShardId shardId, @IndexSettings Settings indexSettings, IndexStore indexStore) {
        super(shardId, indexSettings);
        this.indexStore = (FsIndexStore)indexStore;
    }

    @Override
    public final long throttleTimeInNanos() {
        return this.rateLimitingTimeInNanos.count();
    }

    @Override
    public final StoreRateLimiting rateLimiting() {
        return this.indexStore.rateLimiting();
    }

    protected final LockFactory buildLockFactory() throws IOException {
        String fsLock = this.componentSettings.get("lock", this.componentSettings.get("fs_lock", "native"));
        LockFactory lockFactory = NoLockFactory.getNoLockFactory();
        if (fsLock.equals("native")) {
            lockFactory = new NativeFSLockFactory();
        } else if (fsLock.equals("simple")) {
            lockFactory = new SimpleFSLockFactory();
        } else if (fsLock.equals("none")) {
            lockFactory = NoLockFactory.getNoLockFactory();
        }
        return lockFactory;
    }

    @Override
    public final void renameFile(Directory dir, String from2, String to2) throws IOException {
        FSDirectory fsDirectory = DirectoryUtils.getLeaf(dir, FSDirectory.class);
        if (fsDirectory == null) {
            throw new ElasticSearchIllegalArgumentException("Can not rename file on non-filesystem based directory ");
        }
        File directory = fsDirectory.getDirectory();
        File old = new File(directory, from2);
        File nu = new File(directory, to2);
        if (nu.exists() && !nu.delete()) {
            throw new IOException("Cannot delete " + nu);
        }
        if (!old.exists()) {
            throw new FileNotFoundException("Can't rename from [" + from2 + "] to [" + to2 + "], from does not exists");
        }
        boolean renamed = false;
        for (int i = 0; i < 3; ++i) {
            if (old.renameTo(nu)) {
                renamed = true;
                break;
            }
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException(e.getMessage());
            }
        }
        if (!renamed) {
            throw new IOException("Failed to rename, from [" + from2 + "], to [" + to2 + "]");
        }
    }

    @Override
    public final void fullDelete(Directory dir) throws IOException {
        FSDirectory fsDirectory = DirectoryUtils.getLeaf(dir, FSDirectory.class);
        if (fsDirectory == null) {
            throw new ElasticSearchIllegalArgumentException("Can not fully delete on non-filesystem based directory");
        }
        FileSystemUtils.deleteRecursively(fsDirectory.getDirectory());
        String[] list2 = fsDirectory.getDirectory().getParentFile().list();
        if (list2 == null || list2.length == 0) {
            FileSystemUtils.deleteRecursively(fsDirectory.getDirectory().getParentFile());
        }
    }

    @Override
    public Directory[] build() throws IOException {
        File[] locations = this.indexStore.shardIndexLocations(this.shardId);
        Directory[] dirs = new Directory[locations.length];
        for (int i = 0; i < dirs.length; ++i) {
            FileSystemUtils.mkdirs(locations[i]);
            FSDirectory wrapped = this.newFSDirectory(locations[i], this.buildLockFactory());
            dirs[i] = new RateLimitedFSDirectory(wrapped, this, this);
        }
        return dirs;
    }

    protected abstract FSDirectory newFSDirectory(File var1, LockFactory var2) throws IOException;

    @Override
    public final void onPause(long nanos) {
        this.rateLimitingTimeInNanos.inc(nanos);
    }
}

