/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store.distributor;

import java.io.IOException;
import org.apache.lucene.store.Directory;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.jsr166y.ThreadLocalRandom;
import org.elasticsearch.index.store.DirectoryService;
import org.elasticsearch.index.store.distributor.AbstractDistributor;

public class LeastUsedDistributor
extends AbstractDistributor {
    @Inject
    public LeastUsedDistributor(DirectoryService directoryService) throws IOException {
        super(directoryService);
    }

    @Override
    public Directory doAny() {
        Directory directory = null;
        long size2 = Long.MIN_VALUE;
        int sameSize = 0;
        for (Directory delegate : this.delegates) {
            long currentSize = this.getUsableSpace(delegate);
            if (currentSize > size2) {
                size2 = currentSize;
                directory = delegate;
                sameSize = 1;
                continue;
            }
            if (currentSize != size2) continue;
            ++sameSize;
            if (!(ThreadLocalRandom.current().nextDouble() < 1.0 / (double)sameSize)) continue;
            directory = delegate;
        }
        return directory;
    }

    @Override
    public String name() {
        return "least_used";
    }
}

