/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.Adler32;
import org.apache.lucene.store.BaseDirectory;
import org.apache.lucene.store.BufferedChecksumIndexOutput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.SimpleFSDirectory;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.compress.Compressor;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.Directories;
import org.elasticsearch.common.lucene.store.ChecksumIndexOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.index.CloseableIndexComponent;
import org.elasticsearch.index.codec.CodecService;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.DirectoryService;
import org.elasticsearch.index.store.IndexStore;
import org.elasticsearch.index.store.StoreFileMetaData;
import org.elasticsearch.index.store.StoreStats;
import org.elasticsearch.index.store.distributor.Distributor;
import org.elasticsearch.index.store.support.ForceSyncDirectory;

public class Store
extends AbstractIndexShardComponent
implements CloseableIndexComponent {
    static final String CHECKSUMS_PREFIX = "_checksums-";
    private final IndexStore indexStore;
    final CodecService codecService;
    private final DirectoryService directoryService;
    private final StoreDirectory directory;
    private volatile ImmutableOpenMap<String, StoreFileMetaData> filesMetadata = ImmutableOpenMap.of();
    private volatile String[] files = Strings.EMPTY_ARRAY;
    private final Object mutex = new Object();
    private final boolean sync;

    public static final boolean isChecksum(String name) {
        return name.startsWith(CHECKSUMS_PREFIX);
    }

    @Inject
    public Store(ShardId shardId, @IndexSettings Settings indexSettings, IndexStore indexStore, CodecService codecService, DirectoryService directoryService, Distributor distributor) throws IOException {
        super(shardId, indexSettings);
        this.indexStore = indexStore;
        this.codecService = codecService;
        this.directoryService = directoryService;
        this.sync = this.componentSettings.getAsBoolean("sync", (Boolean)true);
        this.directory = new StoreDirectory(distributor);
    }

    public IndexStore indexStore() {
        return this.indexStore;
    }

    public Directory directory() {
        return this.directory;
    }

    public ImmutableMap<String, StoreFileMetaData> list() throws IOException {
        ImmutableMap.Builder<String, StoreFileMetaData> builder = ImmutableMap.builder();
        for (String name : this.files) {
            StoreFileMetaData md = this.metaData(name);
            if (md == null) continue;
            builder.put(md.name(), md);
        }
        return builder.build();
    }

    public StoreFileMetaData metaData(String name) throws IOException {
        StoreFileMetaData md = this.filesMetadata.get(name);
        if (md == null) {
            return null;
        }
        if (md.length() == -1L) {
            return null;
        }
        return md;
    }

    public void deleteContent() throws IOException {
        String[] files = this.directory.listAll();
        IOException lastException = null;
        for (String file : files) {
            if (Store.isChecksum(file)) {
                try {
                    this.directory.deleteFileChecksum(file);
                }
                catch (IOException e) {
                    lastException = e;
                }
                continue;
            }
            try {
                this.directory.deleteFile(file);
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException e) {
                lastException = e;
            }
        }
        if (lastException != null) {
            throw lastException;
        }
    }

    public StoreStats stats() throws IOException {
        return new StoreStats(Directories.estimateSize(this.directory), this.directoryService.throttleTimeInNanos());
    }

    public ByteSizeValue estimateSize() throws IOException {
        return new ByteSizeValue(Directories.estimateSize(this.directory));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameFile(String from2, String to2) throws IOException {
        Object object = this.mutex;
        synchronized (object) {
            StoreFileMetaData fromMetaData = this.filesMetadata.get(from2);
            if (fromMetaData == null) {
                throw new FileNotFoundException(from2);
            }
            this.directoryService.renameFile(fromMetaData.directory(), from2, to2);
            StoreFileMetaData toMetaData = new StoreFileMetaData(to2, fromMetaData.length(), fromMetaData.checksum(), fromMetaData.directory());
            this.filesMetadata = ImmutableOpenMap.builder(this.filesMetadata).fRemove(from2).fPut(to2, toMetaData).build();
            this.files = this.filesMetadata.keys().toArray(String.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> readChecksums(File[] locations) throws IOException {
        Directory[] dirs = new Directory[locations.length];
        try {
            for (int i = 0; i < locations.length; ++i) {
                dirs[i] = new SimpleFSDirectory(locations[i]);
            }
            Map<String, String> map2 = Store.readChecksums(dirs, null);
            return map2;
        }
        finally {
            for (Directory dir : dirs) {
                if (dir == null) continue;
                try {
                    dir.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<String, String> readChecksums(Directory[] dirs, Map<String, String> defaultValue) throws IOException {
        long lastFound = -1L;
        Directory lastDir = null;
        for (Directory dir : dirs) {
            for (String name : dir.listAll()) {
                long current;
                if (!Store.isChecksum(name) || (current = Long.parseLong(name.substring(CHECKSUMS_PREFIX.length()))) <= lastFound) continue;
                lastFound = current;
                lastDir = dir;
            }
        }
        if (lastFound == -1L) {
            return defaultValue;
        }
        IndexInput indexInput = lastDir.openInput(CHECKSUMS_PREFIX + lastFound, IOContext.READONCE);
        try {
            indexInput.readInt();
            Map<String, String> len$ = indexInput.readStringStringMap();
            return len$;
        }
        catch (Throwable e) {
            Map<String, String> map2 = defaultValue;
            return map2;
        }
        finally {
            indexInput.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeChecksums() throws IOException {
        ImmutableMap<String, StoreFileMetaData> files = this.list();
        String checksumName = CHECKSUMS_PREFIX + System.currentTimeMillis();
        Object object = this.mutex;
        synchronized (object) {
            HashMap<String, String> checksums = new HashMap<String, String>();
            for (StoreFileMetaData metaData : files.values()) {
                if (metaData.checksum() == null) continue;
                checksums.put(metaData.name(), metaData.checksum());
            }
            while (this.directory.fileExists(checksumName)) {
                checksumName = CHECKSUMS_PREFIX + System.currentTimeMillis();
            }
            IndexOutput output2 = this.directory.createOutput(checksumName, IOContext.DEFAULT, true);
            try {
                output2.writeInt(0);
                output2.writeStringStringMap(checksums);
            }
            finally {
                output2.close();
            }
        }
        for (StoreFileMetaData metaData : files.values()) {
            if (!metaData.name().startsWith(CHECKSUMS_PREFIX) || checksumName.equals(metaData.name())) continue;
            try {
                this.directory.deleteFileChecksum(metaData.name());
            }
            catch (Throwable e) {}
        }
    }

    public boolean suggestUseCompoundFile() {
        return false;
    }

    @Override
    public void close() {
        try {
            this.directory.close();
        }
        catch (IOException e) {
            this.logger.debug("failed to close directory", e, new Object[0]);
        }
    }

    public IndexOutput createOutputRaw(String name) throws IOException {
        return this.directory.createOutput(name, IOContext.DEFAULT, true);
    }

    public IndexInput openInputRaw(String name, IOContext context) throws IOException {
        StoreFileMetaData metaData = this.filesMetadata.get(name);
        if (metaData == null) {
            throw new FileNotFoundException(name);
        }
        return metaData.directory().openInput(name, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeChecksum(String name, String checksum) throws IOException {
        Object object = this.mutex;
        synchronized (object) {
            StoreFileMetaData metaData = this.filesMetadata.get(name);
            metaData = new StoreFileMetaData(metaData.name(), metaData.length(), checksum, metaData.directory());
            this.filesMetadata = ImmutableOpenMap.builder(this.filesMetadata).fPut(name, metaData).build();
            this.writeChecksums();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeChecksums(Map<String, String> checksums) throws IOException {
        Object object = this.mutex;
        synchronized (object) {
            for (Map.Entry<String, String> entry2 : checksums.entrySet()) {
                StoreFileMetaData metaData = this.filesMetadata.get(entry2.getKey());
                metaData = new StoreFileMetaData(metaData.name(), metaData.length(), entry2.getValue(), metaData.directory());
                this.filesMetadata = ImmutableOpenMap.builder(this.filesMetadata).fPut(entry2.getKey(), metaData).build();
            }
            this.writeChecksums();
        }
    }

    static /* synthetic */ String[] access$202(Store x0, String[] x1) {
        x0.files = x1;
        return x1;
    }

    class StoreIndexOutput
    extends IndexOutput {
        private final StoreFileMetaData metaData;
        private final IndexOutput out;
        private final String name;

        StoreIndexOutput(StoreFileMetaData metaData, IndexOutput delegate, String name) {
            this.metaData = metaData;
            this.out = delegate;
            this.name = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            this.out.close();
            String checksum = null;
            IndexOutput underlying = this.out;
            if (underlying instanceof BufferedChecksumIndexOutput) {
                checksum = Long.toString(((BufferedChecksumIndexOutput)underlying).digest().getValue(), 36);
            } else if (underlying instanceof ChecksumIndexOutput) {
                checksum = Long.toString(((ChecksumIndexOutput)underlying).digest().getValue(), 36);
            }
            Object object = Store.this.mutex;
            synchronized (object) {
                StoreFileMetaData md = new StoreFileMetaData(this.name, this.metaData.directory().fileLength(this.name), checksum, this.metaData.directory());
                Store.this.filesMetadata = ImmutableOpenMap.builder(Store.this.filesMetadata).fPut(this.name, md).build();
                Store.access$202(Store.this, Store.this.filesMetadata.keys().toArray(String.class));
            }
        }

        @Override
        public void copyBytes(DataInput input2, long numBytes) throws IOException {
            this.out.copyBytes(input2, numBytes);
        }

        @Override
        public long getFilePointer() {
            return this.out.getFilePointer();
        }

        @Override
        public void writeByte(byte b) throws IOException {
            this.out.writeByte(b);
        }

        @Override
        public void writeBytes(byte[] b, int offset, int length) throws IOException {
            this.out.writeBytes(b, offset, length);
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void seek(long pos) throws IOException {
            this.out.seek(pos);
        }

        @Override
        public long length() throws IOException {
            return this.out.length();
        }

        @Override
        public void setLength(long length) throws IOException {
            this.out.setLength(length);
        }

        public String toString() {
            return this.out.toString();
        }
    }

    public class StoreDirectory
    extends BaseDirectory
    implements ForceSyncDirectory {
        private final Distributor distributor;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        StoreDirectory(Distributor distributor) throws IOException {
            this.distributor = distributor;
            Object object = Store.this.mutex;
            synchronized (object) {
                ImmutableOpenMap.Builder<String, StoreFileMetaData> builder = ImmutableOpenMap.builder();
                Map<String, String> checksums = Store.readChecksums(distributor.all(), new HashMap<String, String>());
                for (Directory delegate : distributor.all()) {
                    for (String file : delegate.listAll()) {
                        String checksum = checksums.get(file);
                        builder.put(file, new StoreFileMetaData(file, delegate.fileLength(file), checksum, delegate));
                    }
                }
                Store.this.filesMetadata = builder.build();
                Store.access$202(Store.this, Store.this.filesMetadata.keys().toArray(String.class));
            }
        }

        public ShardId shardId() {
            return Store.this.shardId();
        }

        public Settings settings() {
            return Store.this.indexSettings();
        }

        @Nullable
        public CodecService codecService() {
            return Store.this.codecService;
        }

        public Directory[] delegates() {
            return this.distributor.all();
        }

        @Override
        public void copy(Directory to2, String src, String dest, IOContext context) throws IOException {
            this.ensureOpen();
            super.copy(to2, src, dest, context);
        }

        @Override
        public String[] listAll() throws IOException {
            this.ensureOpen();
            return Store.this.files;
        }

        @Override
        public boolean fileExists(String name) throws IOException {
            this.ensureOpen();
            return Store.this.filesMetadata.containsKey(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deleteFileChecksum(String name) throws IOException {
            block6: {
                this.ensureOpen();
                StoreFileMetaData metaData = (StoreFileMetaData)Store.this.filesMetadata.get(name);
                if (metaData != null) {
                    try {
                        metaData.directory().deleteFile(name);
                    }
                    catch (IOException e) {
                        if (!metaData.directory().fileExists(name)) break block6;
                        throw e;
                    }
                }
            }
            Object object = Store.this.mutex;
            synchronized (object) {
                Store.this.filesMetadata = ImmutableOpenMap.builder(Store.this.filesMetadata).fRemove(name).build();
                Store.access$202(Store.this, Store.this.filesMetadata.keys().toArray(String.class));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void deleteFile(String name) throws IOException {
            block7: {
                this.ensureOpen();
                if (Store.isChecksum(name)) {
                    return;
                }
                StoreFileMetaData metaData = (StoreFileMetaData)Store.this.filesMetadata.get(name);
                if (metaData != null) {
                    try {
                        metaData.directory().deleteFile(name);
                    }
                    catch (IOException e) {
                        if (!metaData.directory().fileExists(name)) break block7;
                        throw e;
                    }
                }
            }
            Object object = Store.this.mutex;
            synchronized (object) {
                Store.this.filesMetadata = ImmutableOpenMap.builder(Store.this.filesMetadata).fRemove(name).build();
                Store.access$202(Store.this, Store.this.filesMetadata.keys().toArray(String.class));
            }
        }

        @Override
        public long fileLength(String name) throws IOException {
            this.ensureOpen();
            StoreFileMetaData metaData = (StoreFileMetaData)Store.this.filesMetadata.get(name);
            if (metaData == null) {
                throw new FileNotFoundException(name);
            }
            if (metaData.length() != -1L) {
                return metaData.length();
            }
            return metaData.directory().fileLength(name);
        }

        @Override
        public IndexOutput createOutput(String name, IOContext context) throws IOException {
            return this.createOutput(name, context, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public IndexOutput createOutput(String name, IOContext context, boolean raw) throws IOException {
            StoreIndexOutput storeIndexOutput;
            block8: {
                this.ensureOpen();
                Directory directory = Store.isChecksum(name) || "segments.gen".equals(name) ? this.distributor.primary() : this.distributor.any();
                IndexOutput out = directory.createOutput(name, context);
                boolean success2 = false;
                try {
                    Object object = Store.this.mutex;
                    synchronized (object) {
                        boolean computeChecksum;
                        StoreFileMetaData metaData = new StoreFileMetaData(name, -1L, null, directory);
                        Store.this.filesMetadata = ImmutableOpenMap.builder(Store.this.filesMetadata).fPut(name, metaData).build();
                        Store.access$202(Store.this, Store.this.filesMetadata.keys().toArray(String.class));
                        boolean bl = computeChecksum = !raw;
                        if (computeChecksum && ("segments.gen".equals(name) || name.startsWith("segments"))) {
                            computeChecksum = false;
                        }
                        if (computeChecksum) {
                            out = new BufferedChecksumIndexOutput(out, new Adler32());
                        }
                        StoreIndexOutput storeIndexOutput2 = new StoreIndexOutput(metaData, out, name);
                        success2 = true;
                        storeIndexOutput = storeIndexOutput2;
                        if (success2) break block8;
                    }
                }
                catch (Throwable throwable) {
                    if (!success2) {
                        IOUtils.closeWhileHandlingException(out);
                    }
                    throw throwable;
                }
                IOUtils.closeWhileHandlingException(out);
            }
            return storeIndexOutput;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public IndexInput openInput(String name, IOContext context) throws IOException {
            this.ensureOpen();
            StoreFileMetaData metaData = (StoreFileMetaData)Store.this.filesMetadata.get(name);
            if (metaData == null) {
                throw new FileNotFoundException(name);
            }
            IndexInput in = metaData.directory().openInput(name, context);
            boolean success2 = false;
            try {
                Compressor compressor;
                if ((name.endsWith(".fdt") || name.endsWith(".tvf")) && (compressor = CompressorFactory.compressor(in)) != null) {
                    return compressor.indexInput(in);
                }
                success2 = true;
                if (success2) return in;
            }
            catch (Throwable throwable) {
                if (success2) throw throwable;
                IOUtils.closeWhileHandlingException(in);
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(in);
            return in;
        }

        @Override
        public Directory.IndexInputSlicer createSlicer(String name, IOContext context) throws IOException {
            this.ensureOpen();
            StoreFileMetaData metaData = (StoreFileMetaData)Store.this.filesMetadata.get(name);
            if (metaData == null) {
                throw new FileNotFoundException(name);
            }
            if (name.endsWith(".fdt") || name.endsWith(".tvf")) {
                return super.createSlicer(name, context);
            }
            return metaData.directory().createSlicer(name, context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void close() throws IOException {
            this.isOpen = false;
            for (Directory delegate : this.distributor.all()) {
                delegate.close();
            }
            Object object = Store.this.mutex;
            synchronized (object) {
                Store.this.filesMetadata = ImmutableOpenMap.of();
                Store.access$202(Store.this, Strings.EMPTY_ARRAY);
            }
        }

        @Override
        public Lock makeLock(String name) {
            return this.distributor.primary().makeLock(name);
        }

        @Override
        public void clearLock(String name) throws IOException {
            this.distributor.primary().clearLock(name);
        }

        @Override
        public void setLockFactory(LockFactory lockFactory) throws IOException {
            this.distributor.primary().setLockFactory(lockFactory);
        }

        @Override
        public LockFactory getLockFactory() {
            return this.distributor.primary().getLockFactory();
        }

        @Override
        public String getLockID() {
            return this.distributor.primary().getLockID();
        }

        @Override
        public void sync(Collection<String> names) throws IOException {
            this.ensureOpen();
            if (Store.this.sync) {
                HashMap map2 = Maps.newHashMap();
                for (String string2 : names) {
                    StoreFileMetaData metaData = (StoreFileMetaData)Store.this.filesMetadata.get(string2);
                    if (metaData == null) {
                        throw new FileNotFoundException(string2);
                    }
                    ArrayList<String> dirNames = (ArrayList<String>)map2.get(metaData.directory());
                    if (dirNames == null) {
                        dirNames = new ArrayList<String>();
                        map2.put(metaData.directory(), dirNames);
                    }
                    dirNames.add(string2);
                }
                for (Map.Entry entry2 : map2.entrySet()) {
                    ((Directory)entry2.getKey()).sync((Collection)entry2.getValue());
                }
            }
            for (String name : names) {
                if (name.equals("segments.gen") || !name.startsWith("segments")) continue;
                Store.this.writeChecksums();
                break;
            }
        }

        @Override
        public void forceSync(String name) throws IOException {
            this.sync(ImmutableList.of(name));
        }

        @Override
        public String toString() {
            return "store(" + this.distributor.toString() + ")";
        }
    }
}

