/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.similarity;

import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.Scopes;
import org.elasticsearch.common.inject.assistedinject.FactoryProvider;
import org.elasticsearch.common.inject.multibindings.MapBinder;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.similarity.PreBuiltSimilarityProvider;
import org.elasticsearch.index.similarity.Similarities;
import org.elasticsearch.index.similarity.SimilarityLookupService;
import org.elasticsearch.index.similarity.SimilarityProvider;
import org.elasticsearch.index.similarity.SimilarityService;

public class SimilarityModule
extends AbstractModule {
    public static final String SIMILARITY_SETTINGS_PREFIX = "index.similarity";
    private final Settings settings;
    private final Map<String, Class<? extends SimilarityProvider>> similarities = Maps.newHashMap();

    public SimilarityModule(Settings settings) {
        this.settings = settings;
    }

    public void addSimilarity(String name, Class<? extends SimilarityProvider> similarity) {
        this.similarities.put(name, similarity);
    }

    @Override
    protected void configure() {
        HashMap<String, Class<? extends SimilarityProvider>> providers = Maps.newHashMap(this.similarities);
        Map<String, Settings> similaritySettings = this.settings.getGroups(SIMILARITY_SETTINGS_PREFIX);
        for (Map.Entry<String, Settings> entry2 : similaritySettings.entrySet()) {
            String name = entry2.getKey();
            Settings settings = entry2.getValue();
            Class type = settings.getAsClass("type", null, "org.elasticsearch.index.similarity.", "SimilarityProvider");
            if (type == null) {
                throw new ElasticSearchIllegalArgumentException("SimilarityProvider [" + name + "] must have an associated type");
            }
            providers.put(name, type);
        }
        MapBinder<String, SimilarityProvider.Factory> similarityBinder = MapBinder.newMapBinder(this.binder(), String.class, SimilarityProvider.Factory.class);
        for (Map.Entry entry3 : providers.entrySet()) {
            similarityBinder.addBinding((String)entry3.getKey()).toProvider(FactoryProvider.newFactory(SimilarityProvider.Factory.class, (Class)entry3.getValue())).in(Scopes.SINGLETON);
        }
        for (PreBuiltSimilarityProvider.Factory factory : Similarities.listFactories()) {
            if (providers.containsKey(factory.name())) continue;
            similarityBinder.addBinding(factory.name()).toInstance(factory);
        }
        this.bind(SimilarityLookupService.class).asEagerSingleton();
        this.bind(SimilarityService.class).asEagerSingleton();
    }
}

