/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.similarity;

import org.apache.lucene.search.similarities.AfterEffect;
import org.apache.lucene.search.similarities.AfterEffectB;
import org.apache.lucene.search.similarities.AfterEffectL;
import org.apache.lucene.search.similarities.BasicModel;
import org.apache.lucene.search.similarities.BasicModelBE;
import org.apache.lucene.search.similarities.BasicModelD;
import org.apache.lucene.search.similarities.BasicModelG;
import org.apache.lucene.search.similarities.BasicModelIF;
import org.apache.lucene.search.similarities.BasicModelIn;
import org.apache.lucene.search.similarities.BasicModelIne;
import org.apache.lucene.search.similarities.BasicModelP;
import org.apache.lucene.search.similarities.DFRSimilarity;
import org.apache.lucene.search.similarities.Normalization;
import org.apache.lucene.search.similarities.Similarity;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.similarity.AbstractSimilarityProvider;

public class DFRSimilarityProvider
extends AbstractSimilarityProvider {
    private static final ImmutableMap<String, BasicModel> MODEL_CACHE;
    private static final ImmutableMap<String, AfterEffect> EFFECT_CACHE;
    private final DFRSimilarity similarity;

    @Inject
    public DFRSimilarityProvider(@Assisted String name, @Assisted Settings settings) {
        super(name);
        BasicModel basicModel = this.parseBasicModel(settings);
        AfterEffect afterEffect = this.parseAfterEffect(settings);
        Normalization normalization = this.parseNormalization(settings);
        this.similarity = new DFRSimilarity(basicModel, afterEffect, normalization);
    }

    protected BasicModel parseBasicModel(Settings settings) {
        String basicModel = settings.get("basic_model");
        BasicModel model = MODEL_CACHE.get(basicModel);
        if (model == null) {
            throw new ElasticSearchIllegalArgumentException("Unsupported BasicModel [" + basicModel + "]");
        }
        return model;
    }

    protected AfterEffect parseAfterEffect(Settings settings) {
        String afterEffect = settings.get("after_effect");
        AfterEffect effect = EFFECT_CACHE.get(afterEffect);
        if (effect == null) {
            throw new ElasticSearchIllegalArgumentException("Unsupported AfterEffect [" + afterEffect + "]");
        }
        return effect;
    }

    @Override
    public Similarity get() {
        return this.similarity;
    }

    static {
        MapBuilder<String, BasicModel> models = MapBuilder.newMapBuilder();
        models.put("be", new BasicModelBE());
        models.put("d", new BasicModelD());
        models.put("g", new BasicModelG());
        models.put("if", new BasicModelIF());
        models.put("in", new BasicModelIn());
        models.put("ine", new BasicModelIne());
        models.put("p", new BasicModelP());
        MODEL_CACHE = models.immutableMap();
        MapBuilder<String, AfterEffect> effects = MapBuilder.newMapBuilder();
        effects.put("no", new AfterEffect.NoAfterEffect());
        effects.put("b", new AfterEffectB());
        effects.put("l", new AfterEffectL());
        EFFECT_CACHE = effects.immutableMap();
    }
}

