/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.child;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.ToStringUtils;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.cache.recycler.CacheRecycler;
import org.elasticsearch.common.bytes.HashedBytesArray;
import org.elasticsearch.common.hppc.IntObjectOpenHashMap;
import org.elasticsearch.common.hppc.ObjectObjectOpenHashMap;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lucene.search.EmptyScorer;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.common.recycler.RecyclerUtils;
import org.elasticsearch.index.search.child.ScoreType;
import org.elasticsearch.search.internal.SearchContext;

public class TopChildrenQuery
extends Query {
    private static final ParentDocComparator PARENT_DOC_COMP = new ParentDocComparator();
    private final CacheRecycler cacheRecycler;
    private final String parentType;
    private final String childType;
    private final ScoreType scoreType;
    private final int factor;
    private final int incrementalFactor;
    private final Query originalChildQuery;
    private Query rewrittenChildQuery;
    private IndexReader rewriteIndexReader;

    public TopChildrenQuery(Query childQuery, String childType, String parentType, ScoreType scoreType, int factor, int incrementalFactor, CacheRecycler cacheRecycler) {
        this.originalChildQuery = childQuery;
        this.childType = childType;
        this.parentType = parentType;
        this.scoreType = scoreType;
        this.factor = factor;
        this.incrementalFactor = incrementalFactor;
        this.cacheRecycler = cacheRecycler;
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        if (this.rewrittenChildQuery == null) {
            this.rewrittenChildQuery = this.originalChildQuery.rewrite(reader);
            this.rewriteIndexReader = reader;
        }
        return this;
    }

    @Override
    public void extractTerms(Set<Term> terms) {
        this.rewrittenChildQuery.extractTerms(terms);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher) throws IOException {
        Query childQuery;
        Recycler.V<ObjectObjectOpenHashMap<Object, ParentDoc[]>> parentDocs = this.cacheRecycler.hashMap(-1);
        SearchContext searchContext = SearchContext.current();
        searchContext.idCache().refresh(searchContext.searcher().getTopReaderContext().leaves());
        int requestedDocs = searchContext.from() + searchContext.size();
        if (requestedDocs <= 0) {
            requestedDocs = 1;
        }
        int numChildDocs = requestedDocs * this.factor;
        if (this.rewrittenChildQuery == null) {
            childQuery = this.rewrittenChildQuery = searcher.rewrite(this.originalChildQuery);
        } else {
            assert (this.rewriteIndexReader == searcher.getIndexReader());
            childQuery = this.rewrittenChildQuery;
        }
        IndexSearcher indexSearcher = new IndexSearcher(searcher.getIndexReader());
        while (true) {
            parentDocs.v().clear();
            TopDocs topChildDocs = indexSearcher.search(childQuery, numChildDocs);
            int parentHitsResolved = this.resolveParentDocuments(topChildDocs, searchContext, parentDocs);
            if (parentHitsResolved >= requestedDocs || topChildDocs.totalHits <= numChildDocs) break;
            if ((numChildDocs *= this.incrementalFactor) <= topChildDocs.totalHits) continue;
            numChildDocs = topChildDocs.totalHits;
        }
        ParentWeight parentWeight = new ParentWeight(this.rewrittenChildQuery.createWeight(searcher), parentDocs);
        searchContext.addReleasable(parentWeight);
        return parentWeight;
    }

    int resolveParentDocuments(TopDocs topDocs, SearchContext context, Recycler.V<ObjectObjectOpenHashMap<Object, ParentDoc[]>> parentDocs) {
        int parentHitsResolved = 0;
        Recycler.V parentDocsPerReader = this.cacheRecycler.hashMap(context.searcher().getIndexReader().leaves().size());
        for (ScoreDoc scoreDoc : topDocs.scoreDocs) {
            int readerIndex = ReaderUtil.subIndex(scoreDoc.doc, context.searcher().getIndexReader().leaves());
            AtomicReaderContext subContext = context.searcher().getIndexReader().leaves().get(readerIndex);
            int subDoc = scoreDoc.doc - subContext.docBase;
            HashedBytesArray parentId = context.idCache().reader(subContext.reader()).parentIdByDoc(this.parentType, subDoc);
            if (parentId == null) continue;
            for (AtomicReaderContext atomicReaderContext : context.searcher().getIndexReader().leaves()) {
                ParentDoc parentDoc;
                AtomicReader indexReader = atomicReaderContext.reader();
                int parentDocId = context.idCache().reader(indexReader).docById(this.parentType, parentId);
                Bits liveDocs = indexReader.getLiveDocs();
                if (parentDocId == -1 || liveDocs != null && !liveDocs.get(parentDocId)) continue;
                Recycler.V readerParentDocs = (Recycler.V)parentDocsPerReader.v().get(indexReader.getCoreCacheKey());
                if (readerParentDocs == null) {
                    readerParentDocs = this.cacheRecycler.intObjectMap(indexReader.maxDoc());
                    parentDocsPerReader.v().put(indexReader.getCoreCacheKey(), readerParentDocs);
                }
                if ((parentDoc = (ParentDoc)((IntObjectOpenHashMap)readerParentDocs.v()).get(parentDocId)) == null) {
                    ++parentHitsResolved;
                    parentDoc = new ParentDoc();
                    parentDoc.docId = parentDocId;
                    parentDoc.count = 1;
                    parentDoc.maxScore = scoreDoc.score;
                    parentDoc.sumScores = scoreDoc.score;
                    readerParentDocs.v().put(parentDocId, parentDoc);
                    continue;
                }
                ++parentDoc.count;
                parentDoc.sumScores += scoreDoc.score;
                if (!(scoreDoc.score > parentDoc.maxScore)) continue;
                parentDoc.maxScore = scoreDoc.score;
            }
        }
        boolean[] states = parentDocsPerReader.v().allocated;
        KType[] keys = parentDocsPerReader.v().keys;
        VType[] values2 = parentDocsPerReader.v().values;
        for (int i = 0; i < states.length; ++i) {
            if (!states[i]) continue;
            Recycler.V value2 = (Recycler.V)values2[i];
            ParentDoc[] _parentDocs = ((IntObjectOpenHashMap)value2.v()).values().toArray(ParentDoc.class);
            Arrays.sort(_parentDocs, PARENT_DOC_COMP);
            parentDocs.v().put(keys[i], _parentDocs);
            RecyclerUtils.release(value2);
        }
        RecyclerUtils.release(parentDocsPerReader);
        return parentHitsResolved;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        TopChildrenQuery that = (TopChildrenQuery)obj;
        if (!this.originalChildQuery.equals(that.originalChildQuery)) {
            return false;
        }
        if (!this.childType.equals(that.childType)) {
            return false;
        }
        return this.incrementalFactor == that.incrementalFactor;
    }

    @Override
    public int hashCode() {
        int result2 = this.originalChildQuery.hashCode();
        result2 = 31 * result2 + this.parentType.hashCode();
        result2 = 31 * result2 + this.incrementalFactor;
        return result2;
    }

    @Override
    public String toString(String field2) {
        StringBuilder sb = new StringBuilder();
        sb.append("score_child[").append(this.childType).append("/").append(this.parentType).append("](").append(this.originalChildQuery.toString(field2)).append(')');
        sb.append(ToStringUtils.boost(this.getBoost()));
        return sb.toString();
    }

    private static class ParentDoc {
        public int docId;
        public int count;
        public float maxScore = Float.NaN;
        public float sumScores = 0.0f;

        private ParentDoc() {
        }
    }

    private static class ParentDocComparator
    implements Comparator<ParentDoc> {
        private ParentDocComparator() {
        }

        @Override
        public int compare(ParentDoc o1, ParentDoc o2) {
            return o1.docId - o2.docId;
        }
    }

    private static abstract class ParentScorer
    extends Scorer {
        private final ParentDoc spare;
        protected final ParentDoc[] docs;
        protected ParentDoc doc;
        private int index;

        ParentScorer(ParentWeight weight, ParentDoc[] docs) throws IOException {
            super(weight);
            this.doc = this.spare = new ParentDoc();
            this.index = -1;
            this.docs = docs;
            this.spare.docId = -1;
            this.spare.count = -1;
        }

        @Override
        public final int docID() {
            return this.doc.docId;
        }

        @Override
        public final int advance(int target) throws IOException {
            int doc;
            while ((doc = this.nextDoc()) < target) {
            }
            return doc;
        }

        @Override
        public final int nextDoc() throws IOException {
            if (++this.index >= this.docs.length) {
                this.doc = this.spare;
                this.doc.count = 0;
                this.doc.docId = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            this.doc = this.docs[this.index];
            return this.doc.docId;
        }

        @Override
        public final int freq() throws IOException {
            return this.doc.count;
        }

        @Override
        public final long cost() {
            return this.docs.length;
        }
    }

    private class ParentWeight
    extends Weight
    implements Releasable {
        private final Weight queryWeight;
        private final Recycler.V<ObjectObjectOpenHashMap<Object, ParentDoc[]>> parentDocs;

        public ParentWeight(Weight queryWeight, Recycler.V<ObjectObjectOpenHashMap<Object, ParentDoc[]>> parentDocs) throws IOException {
            this.queryWeight = queryWeight;
            this.parentDocs = parentDocs;
        }

        @Override
        public Query getQuery() {
            return TopChildrenQuery.this;
        }

        @Override
        public float getValueForNormalization() throws IOException {
            float sum2 = this.queryWeight.getValueForNormalization();
            return sum2 *= TopChildrenQuery.this.getBoost() * TopChildrenQuery.this.getBoost();
        }

        @Override
        public void normalize(float norm, float topLevelBoost) {
        }

        @Override
        public boolean release() throws ElasticSearchException {
            RecyclerUtils.release(this.parentDocs);
            return true;
        }

        @Override
        public Scorer scorer(AtomicReaderContext context, boolean scoreDocsInOrder, boolean topScorer, Bits acceptDocs) throws IOException {
            ParentDoc[] readerParentDocs = this.parentDocs.v().get(context.reader().getCoreCacheKey());
            if (readerParentDocs != null) {
                if (TopChildrenQuery.this.scoreType == ScoreType.MAX) {
                    return new ParentScorer(this, readerParentDocs){

                        @Override
                        public float score() throws IOException {
                            assert (this.doc.docId >= 0 || this.doc.docId < Integer.MAX_VALUE);
                            return this.doc.maxScore;
                        }
                    };
                }
                if (TopChildrenQuery.this.scoreType == ScoreType.AVG) {
                    return new ParentScorer(this, readerParentDocs){

                        @Override
                        public float score() throws IOException {
                            assert (this.doc.docId >= 0 || this.doc.docId < Integer.MAX_VALUE);
                            return this.doc.sumScores / (float)this.doc.count;
                        }
                    };
                }
                if (TopChildrenQuery.this.scoreType == ScoreType.SUM) {
                    return new ParentScorer(this, readerParentDocs){

                        @Override
                        public float score() throws IOException {
                            assert (this.doc.docId >= 0 || this.doc.docId < Integer.MAX_VALUE);
                            return this.doc.sumScores;
                        }
                    };
                }
                throw new ElasticSearchIllegalStateException("No support for score type [" + (Object)((Object)TopChildrenQuery.this.scoreType) + "]");
            }
            return new EmptyScorer(this);
        }

        @Override
        public Explanation explain(AtomicReaderContext context, int doc) throws IOException {
            return new Explanation(TopChildrenQuery.this.getBoost(), "not implemented yet...");
        }
    }
}

