/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.child;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.ToStringUtils;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.common.bytes.HashedBytesArray;
import org.elasticsearch.common.hppc.ObjectFloatOpenHashMap;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lucene.docset.DocIdSets;
import org.elasticsearch.common.lucene.search.ApplyAcceptedDocsFilter;
import org.elasticsearch.common.lucene.search.NoopCollector;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.common.recycler.RecyclerUtils;
import org.elasticsearch.index.cache.id.IdReaderTypeCache;
import org.elasticsearch.search.internal.SearchContext;

public class ParentQuery
extends Query {
    private final Query originalParentQuery;
    private final String parentType;
    private final Filter childrenFilter;
    private Query rewrittenParentQuery;
    private IndexReader rewriteIndexReader;

    public ParentQuery(Query parentQuery, String parentType, Filter childrenFilter) {
        this.originalParentQuery = parentQuery;
        this.parentType = parentType;
        this.childrenFilter = childrenFilter;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ParentQuery that = (ParentQuery)obj;
        if (!this.originalParentQuery.equals(that.originalParentQuery)) {
            return false;
        }
        return this.parentType.equals(that.parentType);
    }

    @Override
    public int hashCode() {
        int result2 = this.originalParentQuery.hashCode();
        result2 = 31 * result2 + this.parentType.hashCode();
        return result2;
    }

    @Override
    public String toString(String field2) {
        StringBuilder sb = new StringBuilder();
        sb.append("ParentQuery[").append(this.parentType).append("](").append(this.originalParentQuery.toString(field2)).append(')').append(ToStringUtils.boost(this.getBoost()));
        return sb.toString();
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        if (this.rewrittenParentQuery == null) {
            this.rewriteIndexReader = reader;
            this.rewrittenParentQuery = this.originalParentQuery.rewrite(reader);
        }
        return this;
    }

    @Override
    public void extractTerms(Set<Term> terms) {
        this.rewrittenParentQuery.extractTerms(terms);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher) throws IOException {
        Query parentQuery;
        SearchContext searchContext = SearchContext.current();
        searchContext.idCache().refresh(searchContext.searcher().getTopReaderContext().leaves());
        Recycler.V uidToScore = searchContext.cacheRecycler().objectFloatMap(-1);
        ParentUidCollector collector = new ParentUidCollector(uidToScore.v(), searchContext, this.parentType);
        if (this.rewrittenParentQuery == null) {
            parentQuery = this.rewrittenParentQuery = searcher.rewrite(this.originalParentQuery);
        } else {
            assert (this.rewriteIndexReader == searcher.getIndexReader());
            parentQuery = this.rewrittenParentQuery;
        }
        IndexSearcher indexSearcher = new IndexSearcher(searcher.getIndexReader());
        indexSearcher.search(parentQuery, collector);
        if (uidToScore.v().isEmpty()) {
            uidToScore.release();
            return Queries.NO_MATCH_QUERY.createWeight(searcher);
        }
        ChildWeight childWeight = new ChildWeight(parentQuery.createWeight(searcher), this.childrenFilter, searchContext, uidToScore);
        searchContext.addReleasable(childWeight);
        return childWeight;
    }

    private static class ChildScorer
    extends Scorer {
        private final ObjectFloatOpenHashMap<HashedBytesArray> uidToScore;
        private final DocIdSetIterator childrenIterator;
        private final IdReaderTypeCache typeCache;
        private int currentChildDoc = -1;
        private float currentScore;

        ChildScorer(Weight weight, ObjectFloatOpenHashMap<HashedBytesArray> uidToScore, DocIdSetIterator childrenIterator, IdReaderTypeCache typeCache) {
            super(weight);
            this.uidToScore = uidToScore;
            this.childrenIterator = childrenIterator;
            this.typeCache = typeCache;
        }

        @Override
        public float score() throws IOException {
            return this.currentScore;
        }

        @Override
        public int freq() throws IOException {
            return 1;
        }

        @Override
        public int docID() {
            return this.currentChildDoc;
        }

        @Override
        public int nextDoc() throws IOException {
            HashedBytesArray uid;
            do {
                this.currentChildDoc = this.childrenIterator.nextDoc();
                if (this.currentChildDoc != Integer.MAX_VALUE) continue;
                return this.currentChildDoc;
            } while ((uid = this.typeCache.parentIdByDoc(this.currentChildDoc)) == null || !this.uidToScore.containsKey(uid));
            this.currentScore = this.uidToScore.lget();
            return this.currentChildDoc;
        }

        @Override
        public int advance(int target) throws IOException {
            this.currentChildDoc = this.childrenIterator.advance(target);
            if (this.currentChildDoc == Integer.MAX_VALUE) {
                return this.currentChildDoc;
            }
            HashedBytesArray uid = this.typeCache.parentIdByDoc(this.currentChildDoc);
            if (uid == null) {
                return this.nextDoc();
            }
            if (this.uidToScore.containsKey(uid)) {
                this.currentScore = this.uidToScore.lget();
                return this.currentChildDoc;
            }
            return this.nextDoc();
        }

        @Override
        public long cost() {
            return this.childrenIterator.cost();
        }
    }

    private class ChildWeight
    extends Weight
    implements Releasable {
        private final Weight parentWeight;
        private final Filter childrenFilter;
        private final SearchContext searchContext;
        private final Recycler.V<ObjectFloatOpenHashMap<HashedBytesArray>> uidToScore;

        private ChildWeight(Weight parentWeight, Filter childrenFilter, SearchContext searchContext, Recycler.V<ObjectFloatOpenHashMap<HashedBytesArray>> uidToScore) {
            this.parentWeight = parentWeight;
            this.childrenFilter = new ApplyAcceptedDocsFilter(childrenFilter);
            this.searchContext = searchContext;
            this.uidToScore = uidToScore;
        }

        @Override
        public Explanation explain(AtomicReaderContext context, int doc) throws IOException {
            return new Explanation(ParentQuery.this.getBoost(), "not implemented yet...");
        }

        @Override
        public Query getQuery() {
            return ParentQuery.this;
        }

        @Override
        public float getValueForNormalization() throws IOException {
            float sum2 = this.parentWeight.getValueForNormalization();
            return sum2 *= ParentQuery.this.getBoost() * ParentQuery.this.getBoost();
        }

        @Override
        public void normalize(float norm, float topLevelBoost) {
        }

        @Override
        public Scorer scorer(AtomicReaderContext context, boolean scoreDocsInOrder, boolean topScorer, Bits acceptDocs) throws IOException {
            DocIdSet childrenDocSet = this.childrenFilter.getDocIdSet(context, acceptDocs);
            if (DocIdSets.isEmpty(childrenDocSet)) {
                return null;
            }
            IdReaderTypeCache idTypeCache = this.searchContext.idCache().reader(context.reader()).type(ParentQuery.this.parentType);
            if (idTypeCache == null) {
                return null;
            }
            return new ChildScorer(this, this.uidToScore.v(), childrenDocSet.iterator(), idTypeCache);
        }

        @Override
        public boolean release() throws ElasticSearchException {
            RecyclerUtils.release(this.uidToScore);
            return true;
        }
    }

    private static class ParentUidCollector
    extends NoopCollector {
        private final ObjectFloatOpenHashMap<HashedBytesArray> uidToScore;
        private final SearchContext searchContext;
        private final String parentType;
        private Scorer scorer;
        private IdReaderTypeCache typeCache;

        ParentUidCollector(ObjectFloatOpenHashMap<HashedBytesArray> uidToScore, SearchContext searchContext, String parentType) {
            this.uidToScore = uidToScore;
            this.searchContext = searchContext;
            this.parentType = parentType;
        }

        @Override
        public void collect(int doc) throws IOException {
            if (this.typeCache == null) {
                return;
            }
            HashedBytesArray parentUid = this.typeCache.idByDoc(doc);
            this.uidToScore.put(parentUid, this.scorer.score());
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            this.scorer = scorer;
        }

        @Override
        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.typeCache = this.searchContext.idCache().reader(context.reader()).type(this.parentType);
        }
    }
}

