/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.child;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.elasticsearch.common.bytes.HashedBytesArray;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.mapper.internal.UidFieldMapper;

final class ParentIdsFilter
extends Filter {
    private final BytesRef parentTypeBr;
    private final Object[] keys;
    private final boolean[] allocated;
    private final Filter nonNestedDocsFilter;

    public ParentIdsFilter(String parentType, Object[] keys, boolean[] allocated, Filter nonNestedDocsFilter) {
        this.nonNestedDocsFilter = nonNestedDocsFilter;
        this.parentTypeBr = new BytesRef(parentType);
        this.keys = keys;
        this.allocated = allocated;
    }

    @Override
    public DocIdSet getDocIdSet(AtomicReaderContext context, Bits acceptDocs) throws IOException {
        Terms terms = context.reader().terms(UidFieldMapper.NAME);
        if (terms == null) {
            return null;
        }
        TermsEnum termsEnum = terms.iterator(null);
        BytesRef uidSpare = new BytesRef();
        BytesRef idSpare = new BytesRef();
        if (acceptDocs == null) {
            acceptDocs = context.reader().getLiveDocs();
        }
        FixedBitSet nonNestedDocs = null;
        if (this.nonNestedDocsFilter != null) {
            nonNestedDocs = (FixedBitSet)this.nonNestedDocsFilter.getDocIdSet(context, acceptDocs);
        }
        DocsEnum docsEnum = null;
        FixedBitSet result2 = null;
        for (int i = 0; i < this.allocated.length; ++i) {
            int docId;
            if (!this.allocated[i]) continue;
            idSpare.bytes = ((HashedBytesArray)this.keys[i]).toBytes();
            idSpare.length = idSpare.bytes.length;
            Uid.createUidAsBytes(this.parentTypeBr, idSpare, uidSpare);
            if (!termsEnum.seekExact(uidSpare)) continue;
            docsEnum = termsEnum.docs(acceptDocs, docsEnum, 0);
            if (result2 == null) {
                docId = docsEnum.nextDoc();
                if (docId == Integer.MAX_VALUE) continue;
                result2 = new FixedBitSet(context.reader().maxDoc());
            } else {
                docId = docsEnum.nextDoc();
                if (docId == Integer.MAX_VALUE) continue;
            }
            if (nonNestedDocs != null && !nonNestedDocs.get(docId)) {
                docId = nonNestedDocs.nextSetBit(docId);
            }
            result2.set(docId);
            assert (docsEnum.advance(docId + 1) == Integer.MAX_VALUE) : "DocId " + docId + " should have been the last one but docId " + docsEnum.docID() + " exists.";
        }
        return result2;
    }
}

