/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.child;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredDocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.common.bytes.HashedBytesArray;
import org.elasticsearch.common.hppc.ObjectOpenHashSet;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lucene.docset.DocIdSets;
import org.elasticsearch.common.lucene.search.ApplyAcceptedDocsFilter;
import org.elasticsearch.common.lucene.search.NoopCollector;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.common.recycler.RecyclerUtils;
import org.elasticsearch.index.cache.id.IdReaderTypeCache;
import org.elasticsearch.index.search.child.ConstantScorer;
import org.elasticsearch.search.internal.SearchContext;

public class ParentConstantScoreQuery
extends Query {
    private final Query originalParentQuery;
    private final String parentType;
    private final Filter childrenFilter;
    private Query rewrittenParentQuery;
    private IndexReader rewriteIndexReader;

    public ParentConstantScoreQuery(Query parentQuery, String parentType, Filter childrenFilter) {
        this.originalParentQuery = parentQuery;
        this.parentType = parentType;
        this.childrenFilter = childrenFilter;
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        if (this.rewrittenParentQuery == null) {
            this.rewrittenParentQuery = this.originalParentQuery.rewrite(reader);
            this.rewriteIndexReader = reader;
        }
        return this;
    }

    @Override
    public void extractTerms(Set<Term> terms) {
        this.rewrittenParentQuery.extractTerms(terms);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher) throws IOException {
        Query parentQuery;
        SearchContext searchContext = SearchContext.current();
        searchContext.idCache().refresh(searcher.getTopReaderContext().leaves());
        Recycler.V parents = searchContext.cacheRecycler().hashSet(-1);
        ParentUidsCollector collector = new ParentUidsCollector(parents.v(), searchContext, this.parentType);
        if (this.rewrittenParentQuery != null) {
            parentQuery = this.rewrittenParentQuery;
        } else {
            assert (this.rewriteIndexReader == searcher.getIndexReader());
            parentQuery = this.rewrittenParentQuery = this.originalParentQuery.rewrite(searcher.getIndexReader());
        }
        IndexSearcher indexSearcher = new IndexSearcher(searcher.getIndexReader());
        indexSearcher.search(parentQuery, collector);
        if (parents.v().isEmpty()) {
            return Queries.NO_MATCH_QUERY.createWeight(searcher);
        }
        ChildrenWeight childrenWeight = new ChildrenWeight(this.childrenFilter, searchContext, parents);
        searchContext.addReleasable(childrenWeight);
        return childrenWeight;
    }

    @Override
    public int hashCode() {
        int result2 = this.originalParentQuery.hashCode();
        result2 = 31 * result2 + this.parentType.hashCode();
        return result2;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ParentConstantScoreQuery that = (ParentConstantScoreQuery)obj;
        if (!this.originalParentQuery.equals(that.originalParentQuery)) {
            return false;
        }
        return this.parentType.equals(that.parentType);
    }

    @Override
    public String toString(String field2) {
        StringBuilder sb = new StringBuilder();
        sb.append("parent_filter[").append(this.parentType).append("](").append(this.originalParentQuery).append(')');
        return sb.toString();
    }

    private static final class ParentUidsCollector
    extends NoopCollector {
        private final ObjectOpenHashSet<HashedBytesArray> collectedUids;
        private final SearchContext context;
        private final String parentType;
        private IdReaderTypeCache typeCache;

        ParentUidsCollector(ObjectOpenHashSet<HashedBytesArray> collectedUids, SearchContext context, String parentType) {
            this.collectedUids = collectedUids;
            this.context = context;
            this.parentType = parentType;
        }

        @Override
        public void collect(int doc) throws IOException {
            if (this.typeCache != null) {
                this.collectedUids.add(this.typeCache.idByDoc(doc));
            }
        }

        @Override
        public void setNextReader(AtomicReaderContext readerContext) throws IOException {
            this.typeCache = this.context.idCache().reader(readerContext.reader()).type(this.parentType);
        }
    }

    private final class ChildrenWeight
    extends Weight
    implements Releasable {
        private final Filter childrenFilter;
        private final SearchContext searchContext;
        private final Recycler.V<ObjectOpenHashSet<HashedBytesArray>> parents;
        private float queryNorm;
        private float queryWeight;

        private ChildrenWeight(Filter childrenFilter, SearchContext searchContext, Recycler.V<ObjectOpenHashSet<HashedBytesArray>> parents) {
            this.childrenFilter = new ApplyAcceptedDocsFilter(childrenFilter);
            this.searchContext = searchContext;
            this.parents = parents;
        }

        @Override
        public Explanation explain(AtomicReaderContext context, int doc) throws IOException {
            return new Explanation(ParentConstantScoreQuery.this.getBoost(), "not implemented yet...");
        }

        @Override
        public Query getQuery() {
            return ParentConstantScoreQuery.this;
        }

        @Override
        public float getValueForNormalization() throws IOException {
            this.queryWeight = ParentConstantScoreQuery.this.getBoost();
            return this.queryWeight * this.queryWeight;
        }

        @Override
        public void normalize(float norm, float topLevelBoost) {
            this.queryNorm = norm * topLevelBoost;
            this.queryWeight *= this.queryNorm;
        }

        @Override
        public Scorer scorer(AtomicReaderContext context, boolean scoreDocsInOrder, boolean topScorer, Bits acceptDocs) throws IOException {
            DocIdSetIterator innerIterator;
            DocIdSet childrenDocIdSet = this.childrenFilter.getDocIdSet(context, acceptDocs);
            if (DocIdSets.isEmpty(childrenDocIdSet)) {
                return null;
            }
            IdReaderTypeCache idReaderTypeCache = this.searchContext.idCache().reader(context.reader()).type(ParentConstantScoreQuery.this.parentType);
            if (idReaderTypeCache != null && (innerIterator = childrenDocIdSet.iterator()) != null) {
                ChildrenDocIdIterator childrenDocIdIterator = new ChildrenDocIdIterator(innerIterator, this.parents.v(), idReaderTypeCache);
                return ConstantScorer.create(childrenDocIdIterator, this, this.queryWeight);
            }
            return null;
        }

        @Override
        public boolean release() throws ElasticSearchException {
            RecyclerUtils.release(this.parents);
            return true;
        }

        private final class ChildrenDocIdIterator
        extends FilteredDocIdSetIterator {
            private final ObjectOpenHashSet<HashedBytesArray> parents;
            private final IdReaderTypeCache idReaderTypeCache;

            ChildrenDocIdIterator(DocIdSetIterator innerIterator, ObjectOpenHashSet<HashedBytesArray> parents, IdReaderTypeCache idReaderTypeCache) {
                super(innerIterator);
                this.parents = parents;
                this.idReaderTypeCache = idReaderTypeCache;
            }

            @Override
            protected boolean match(int doc) {
                return this.parents.contains(this.idReaderTypeCache.parentIdByDoc(doc));
            }
        }
    }
}

