/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.child;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.elasticsearch.search.internal.ContextIndexSearcher;
import org.elasticsearch.search.internal.SearchContext;

public class CustomQueryWrappingFilter
extends Filter {
    private final Query query;
    private IndexSearcher searcher;
    private Weight weight;

    public CustomQueryWrappingFilter(Query query) {
        if (query == null) {
            throw new NullPointerException("Query may not be null");
        }
        this.query = query;
    }

    public final Query getQuery() {
        return this.query;
    }

    @Override
    public DocIdSet getDocIdSet(final AtomicReaderContext context, final Bits acceptDocs) throws IOException {
        SearchContext searchContext = SearchContext.current();
        if (this.weight == null) {
            assert (this.searcher == null);
            ContextIndexSearcher searcher = searchContext.searcher();
            this.weight = ((IndexSearcher)searcher).createNormalizedWeight(this.query);
            this.searcher = searcher;
        } else assert (this.searcher == SearchContext.current().searcher());
        return new DocIdSet(){

            @Override
            public DocIdSetIterator iterator() throws IOException {
                return CustomQueryWrappingFilter.this.weight.scorer(context, true, false, acceptDocs);
            }

            @Override
            public boolean isCacheable() {
                return false;
            }
        };
    }

    public String toString() {
        return "CustomQueryWrappingFilter(" + this.query + ")";
    }

    public boolean equals(Object o) {
        if (!(o instanceof CustomQueryWrappingFilter)) {
            return false;
        }
        return this.query.equals(((CustomQueryWrappingFilter)o).query);
    }

    public int hashCode() {
        return this.query.hashCode() ^ 0x823D64C9;
    }
}

