/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.child;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.TermFilter;
import org.apache.lucene.search.BitsFilteredDocIdSet;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredDocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.common.bytes.HashedBytesArray;
import org.elasticsearch.common.hppc.ObjectOpenHashSet;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lucene.docset.DocIdSets;
import org.elasticsearch.common.lucene.search.ApplyAcceptedDocsFilter;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.common.recycler.RecyclerUtils;
import org.elasticsearch.index.cache.id.IdReaderTypeCache;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.mapper.internal.UidFieldMapper;
import org.elasticsearch.index.search.child.ConstantScorer;
import org.elasticsearch.index.search.child.ParentIdCollector;
import org.elasticsearch.index.search.child.ParentIdsFilter;
import org.elasticsearch.search.internal.SearchContext;

public class ChildrenConstantScoreQuery
extends Query {
    private final Query originalChildQuery;
    private final String parentType;
    private final String childType;
    private final Filter parentFilter;
    private final int shortCircuitParentDocSet;
    private final Filter nonNestedDocsFilter;
    private Query rewrittenChildQuery;
    private IndexReader rewriteIndexReader;

    public ChildrenConstantScoreQuery(Query childQuery, String parentType, String childType, Filter parentFilter, int shortCircuitParentDocSet, Filter nonNestedDocsFilter) {
        this.parentFilter = parentFilter;
        this.parentType = parentType;
        this.childType = childType;
        this.originalChildQuery = childQuery;
        this.shortCircuitParentDocSet = shortCircuitParentDocSet;
        this.nonNestedDocsFilter = nonNestedDocsFilter;
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        if (this.rewrittenChildQuery == null) {
            this.rewrittenChildQuery = this.originalChildQuery.rewrite(reader);
            this.rewriteIndexReader = reader;
        }
        return this;
    }

    @Override
    public void extractTerms(Set<Term> terms) {
        this.rewrittenChildQuery.extractTerms(terms);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher) throws IOException {
        Query childQuery;
        SearchContext searchContext = SearchContext.current();
        searchContext.idCache().refresh(searcher.getTopReaderContext().leaves());
        Recycler.V<ObjectOpenHashSet<HashedBytesArray>> collectedUids = searchContext.cacheRecycler().hashSet(-1);
        UidCollector collector = new UidCollector(this.parentType, searchContext, collectedUids.v());
        if (this.rewrittenChildQuery == null) {
            childQuery = this.rewrittenChildQuery = searcher.rewrite(this.originalChildQuery);
        } else {
            assert (this.rewriteIndexReader == searcher.getIndexReader());
            childQuery = this.rewrittenChildQuery;
        }
        IndexSearcher indexSearcher = new IndexSearcher(searcher.getIndexReader());
        indexSearcher.search(childQuery, collector);
        int remaining = collectedUids.v().size();
        if (remaining == 0) {
            return Queries.NO_MATCH_QUERY.createWeight(searcher);
        }
        Filter shortCircuitFilter = null;
        if (remaining == 1) {
            BytesRef id = ((HashedBytesArray)collectedUids.v().iterator().next().value).toBytesRef();
            shortCircuitFilter = new TermFilter(new Term(UidFieldMapper.NAME, Uid.createUidAsBytes(this.parentType, id)));
        } else if (remaining <= this.shortCircuitParentDocSet) {
            shortCircuitFilter = new ParentIdsFilter(this.parentType, collectedUids.v().keys, collectedUids.v().allocated, this.nonNestedDocsFilter);
        }
        ParentWeight parentWeight = new ParentWeight(this.parentFilter, shortCircuitFilter, searchContext, collectedUids);
        searchContext.addReleasable(parentWeight);
        return parentWeight;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ChildrenConstantScoreQuery that = (ChildrenConstantScoreQuery)obj;
        if (!this.originalChildQuery.equals(that.originalChildQuery)) {
            return false;
        }
        if (!this.childType.equals(that.childType)) {
            return false;
        }
        return this.shortCircuitParentDocSet == that.shortCircuitParentDocSet;
    }

    @Override
    public int hashCode() {
        int result2 = this.originalChildQuery.hashCode();
        result2 = 31 * result2 + this.childType.hashCode();
        return result2 += this.shortCircuitParentDocSet;
    }

    @Override
    public String toString(String field2) {
        StringBuilder sb = new StringBuilder();
        sb.append("child_filter[").append(this.childType).append("/").append(this.parentType).append("](").append(this.originalChildQuery).append(')');
        return sb.toString();
    }

    private static final class UidCollector
    extends ParentIdCollector {
        private final ObjectOpenHashSet<HashedBytesArray> collectedUids;

        UidCollector(String parentType, SearchContext context, ObjectOpenHashSet<HashedBytesArray> collectedUids) {
            super(parentType, context);
            this.collectedUids = collectedUids;
        }

        @Override
        public void collect(int doc, HashedBytesArray parentIdByDoc) {
            this.collectedUids.add(parentIdByDoc);
        }
    }

    private final class ParentWeight
    extends Weight
    implements Releasable {
        private final Filter parentFilter;
        private final Filter shortCircuitFilter;
        private final SearchContext searchContext;
        private final Recycler.V<ObjectOpenHashSet<HashedBytesArray>> collectedUids;
        private int remaining;
        private float queryNorm;
        private float queryWeight;

        public ParentWeight(Filter parentFilter, Filter shortCircuitFilter, SearchContext searchContext, Recycler.V<ObjectOpenHashSet<HashedBytesArray>> collectedUids) {
            this.parentFilter = new ApplyAcceptedDocsFilter(parentFilter);
            this.shortCircuitFilter = shortCircuitFilter;
            this.searchContext = searchContext;
            this.collectedUids = collectedUids;
            this.remaining = collectedUids.v().size();
        }

        @Override
        public Explanation explain(AtomicReaderContext context, int doc) throws IOException {
            return new Explanation(ChildrenConstantScoreQuery.this.getBoost(), "not implemented yet...");
        }

        @Override
        public Query getQuery() {
            return ChildrenConstantScoreQuery.this;
        }

        @Override
        public float getValueForNormalization() throws IOException {
            this.queryWeight = ChildrenConstantScoreQuery.this.getBoost();
            return this.queryWeight * this.queryWeight;
        }

        @Override
        public void normalize(float norm, float topLevelBoost) {
            this.queryNorm = norm * topLevelBoost;
            this.queryWeight *= this.queryNorm;
        }

        @Override
        public Scorer scorer(AtomicReaderContext context, boolean scoreDocsInOrder, boolean topScorer, Bits acceptDocs) throws IOException {
            if (this.remaining == 0) {
                return null;
            }
            if (this.shortCircuitFilter != null) {
                DocIdSetIterator iterator2;
                DocIdSet docIdSet = this.shortCircuitFilter.getDocIdSet(context, acceptDocs);
                if (!DocIdSets.isEmpty(docIdSet) && (iterator2 = docIdSet.iterator()) != null) {
                    return ConstantScorer.create(iterator2, this, this.queryWeight);
                }
                return null;
            }
            DocIdSet parentDocIdSet = this.parentFilter.getDocIdSet(context, acceptDocs);
            if (!DocIdSets.isEmpty(parentDocIdSet)) {
                DocIdSetIterator innerIterator;
                IdReaderTypeCache idReaderTypeCache = this.searchContext.idCache().reader(context.reader()).type(ChildrenConstantScoreQuery.this.parentType);
                parentDocIdSet = BitsFilteredDocIdSet.wrap(parentDocIdSet, context.reader().getLiveDocs());
                if (idReaderTypeCache != null && (innerIterator = parentDocIdSet.iterator()) != null) {
                    ParentDocIdIterator parentDocIdIterator = new ParentDocIdIterator(innerIterator, this.collectedUids.v(), idReaderTypeCache);
                    return ConstantScorer.create(parentDocIdIterator, this, this.queryWeight);
                }
            }
            return null;
        }

        @Override
        public boolean release() throws ElasticSearchException {
            RecyclerUtils.release(this.collectedUids);
            return true;
        }

        private final class ParentDocIdIterator
        extends FilteredDocIdSetIterator {
            private final ObjectOpenHashSet<HashedBytesArray> parents;
            private final IdReaderTypeCache typeCache;

            private ParentDocIdIterator(DocIdSetIterator innerIterator, ObjectOpenHashSet<HashedBytesArray> parents, IdReaderTypeCache typeCache) {
                super(innerIterator);
                this.parents = parents;
                this.typeCache = typeCache;
            }

            @Override
            protected boolean match(int doc) {
                if (ParentWeight.this.remaining == 0) {
                    try {
                        this.advance(Integer.MAX_VALUE);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    return false;
                }
                boolean match = this.parents.contains(this.typeCache.idByDoc(doc));
                if (match) {
                    ParentWeight.this.remaining--;
                }
                return match;
            }
        }
    }
}

