/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.common.lucene.docset.MatchDocIdSet;
import org.elasticsearch.index.fielddata.DoubleValues;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.LongValues;

public abstract class NumericRangeFieldDataFilter<T>
extends Filter {
    final IndexNumericFieldData indexFieldData;
    final T lowerVal;
    final T upperVal;
    final boolean includeLower;
    final boolean includeUpper;

    public String getField() {
        return this.indexFieldData.getFieldNames().indexName();
    }

    public T getLowerVal() {
        return this.lowerVal;
    }

    public T getUpperVal() {
        return this.upperVal;
    }

    public boolean isIncludeLower() {
        return this.includeLower;
    }

    public boolean isIncludeUpper() {
        return this.includeUpper;
    }

    protected NumericRangeFieldDataFilter(IndexNumericFieldData indexFieldData, T lowerVal, T upperVal, boolean includeLower, boolean includeUpper) {
        this.indexFieldData = indexFieldData;
        this.lowerVal = lowerVal;
        this.upperVal = upperVal;
        this.includeLower = includeLower;
        this.includeUpper = includeUpper;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder(this.indexFieldData.getFieldNames().indexName()).append(":");
        return sb.append(this.includeLower ? (char)'[' : '{').append(this.lowerVal == null ? "*" : this.lowerVal.toString()).append(" TO ").append(this.upperVal == null ? "*" : this.upperVal.toString()).append(this.includeUpper ? (char)']' : '}').toString();
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NumericRangeFieldDataFilter)) {
            return false;
        }
        NumericRangeFieldDataFilter other = (NumericRangeFieldDataFilter)o;
        if (!this.indexFieldData.getFieldNames().indexName().equals(other.indexFieldData.getFieldNames().indexName()) || this.includeLower != other.includeLower || this.includeUpper != other.includeUpper) {
            return false;
        }
        if (this.lowerVal != null ? !this.lowerVal.equals(other.lowerVal) : other.lowerVal != null) {
            return false;
        }
        return !(this.upperVal != null ? !this.upperVal.equals(other.upperVal) : other.upperVal != null);
    }

    public final int hashCode() {
        int h = this.indexFieldData.getFieldNames().indexName().hashCode();
        h ^= this.lowerVal != null ? this.lowerVal.hashCode() : 550356204;
        h = h << 1 | h >>> 31;
        h ^= this.upperVal != null ? this.upperVal.hashCode() : -1674416163;
        return h ^= (this.includeLower ? 1549299360 : -365038026) ^ (this.includeUpper ? 1721088258 : 1948649653);
    }

    public static NumericRangeFieldDataFilter<Byte> newByteRange(IndexNumericFieldData indexFieldData, Byte lowerVal, Byte upperVal, boolean includeLower, boolean includeUpper) {
        return new NumericRangeFieldDataFilter<Byte>(indexFieldData, lowerVal, upperVal, includeLower, includeUpper){

            @Override
            public DocIdSet getDocIdSet(AtomicReaderContext ctx, Bits acceptedDocs) throws IOException {
                int inclusiveUpperPoint;
                int inclusiveLowerPoint;
                int i;
                if (this.lowerVal != null) {
                    i = ((Byte)this.lowerVal).byteValue();
                    if (!this.includeLower && i == 127) {
                        return null;
                    }
                    inclusiveLowerPoint = (byte)(this.includeLower ? i : i + 1);
                } else {
                    inclusiveLowerPoint = -128;
                }
                if (this.upperVal != null) {
                    i = ((Byte)this.upperVal).byteValue();
                    if (!this.includeUpper && i == -128) {
                        return null;
                    }
                    inclusiveUpperPoint = (byte)(this.includeUpper ? i : i - 1);
                } else {
                    inclusiveUpperPoint = 127;
                }
                if (inclusiveLowerPoint > inclusiveUpperPoint) {
                    return null;
                }
                LongValues values2 = this.indexFieldData.load(ctx).getLongValues();
                return new LongRangeMatchDocIdSet(ctx.reader().maxDoc(), acceptedDocs, values2, inclusiveLowerPoint, inclusiveUpperPoint);
            }
        };
    }

    public static NumericRangeFieldDataFilter<Short> newShortRange(IndexNumericFieldData indexFieldData, Short lowerVal, Short upperVal, boolean includeLower, boolean includeUpper) {
        return new NumericRangeFieldDataFilter<Short>(indexFieldData, lowerVal, upperVal, includeLower, includeUpper){

            @Override
            public DocIdSet getDocIdSet(AtomicReaderContext ctx, Bits acceptedDocs) throws IOException {
                int inclusiveUpperPoint;
                int inclusiveLowerPoint;
                int i;
                if (this.lowerVal != null) {
                    i = ((Short)this.lowerVal).shortValue();
                    if (!this.includeLower && i == Short.MAX_VALUE) {
                        return null;
                    }
                    inclusiveLowerPoint = (short)(this.includeLower ? i : i + 1);
                } else {
                    inclusiveLowerPoint = Short.MIN_VALUE;
                }
                if (this.upperVal != null) {
                    i = ((Short)this.upperVal).shortValue();
                    if (!this.includeUpper && i == Short.MIN_VALUE) {
                        return null;
                    }
                    inclusiveUpperPoint = (short)(this.includeUpper ? i : i - 1);
                } else {
                    inclusiveUpperPoint = Short.MAX_VALUE;
                }
                if (inclusiveLowerPoint > inclusiveUpperPoint) {
                    return null;
                }
                LongValues values2 = this.indexFieldData.load(ctx).getLongValues();
                return new LongRangeMatchDocIdSet(ctx.reader().maxDoc(), acceptedDocs, values2, inclusiveLowerPoint, inclusiveUpperPoint);
            }
        };
    }

    public static NumericRangeFieldDataFilter<Integer> newIntRange(IndexNumericFieldData indexFieldData, Integer lowerVal, Integer upperVal, boolean includeLower, boolean includeUpper) {
        return new NumericRangeFieldDataFilter<Integer>(indexFieldData, lowerVal, upperVal, includeLower, includeUpper){

            @Override
            public DocIdSet getDocIdSet(AtomicReaderContext ctx, Bits acceptedDocs) throws IOException {
                int inclusiveUpperPoint;
                int inclusiveLowerPoint;
                int i;
                if (this.lowerVal != null) {
                    i = (Integer)this.lowerVal;
                    if (!this.includeLower && i == Integer.MAX_VALUE) {
                        return null;
                    }
                    inclusiveLowerPoint = this.includeLower ? i : i + 1;
                } else {
                    inclusiveLowerPoint = Integer.MIN_VALUE;
                }
                if (this.upperVal != null) {
                    i = (Integer)this.upperVal;
                    if (!this.includeUpper && i == Integer.MIN_VALUE) {
                        return null;
                    }
                    inclusiveUpperPoint = this.includeUpper ? i : i - 1;
                } else {
                    inclusiveUpperPoint = Integer.MAX_VALUE;
                }
                if (inclusiveLowerPoint > inclusiveUpperPoint) {
                    return null;
                }
                LongValues values2 = this.indexFieldData.load(ctx).getLongValues();
                return new LongRangeMatchDocIdSet(ctx.reader().maxDoc(), acceptedDocs, values2, inclusiveLowerPoint, inclusiveUpperPoint);
            }
        };
    }

    public static NumericRangeFieldDataFilter<Long> newLongRange(IndexNumericFieldData indexFieldData, Long lowerVal, Long upperVal, boolean includeLower, boolean includeUpper) {
        return new NumericRangeFieldDataFilter<Long>(indexFieldData, lowerVal, upperVal, includeLower, includeUpper){

            @Override
            public DocIdSet getDocIdSet(AtomicReaderContext ctx, Bits acceptedDocs) throws IOException {
                long inclusiveUpperPoint;
                long inclusiveLowerPoint;
                long i;
                if (this.lowerVal != null) {
                    i = (Long)this.lowerVal;
                    if (!this.includeLower && i == Long.MAX_VALUE) {
                        return null;
                    }
                    inclusiveLowerPoint = this.includeLower ? i : i + 1L;
                } else {
                    inclusiveLowerPoint = Long.MIN_VALUE;
                }
                if (this.upperVal != null) {
                    i = (Long)this.upperVal;
                    if (!this.includeUpper && i == Long.MIN_VALUE) {
                        return null;
                    }
                    inclusiveUpperPoint = this.includeUpper ? i : i - 1L;
                } else {
                    inclusiveUpperPoint = Long.MAX_VALUE;
                }
                if (inclusiveLowerPoint > inclusiveUpperPoint) {
                    return null;
                }
                LongValues values2 = this.indexFieldData.load(ctx).getLongValues();
                return new LongRangeMatchDocIdSet(ctx.reader().maxDoc(), acceptedDocs, values2, inclusiveLowerPoint, inclusiveUpperPoint);
            }
        };
    }

    public static NumericRangeFieldDataFilter<Float> newFloatRange(IndexNumericFieldData indexFieldData, Float lowerVal, Float upperVal, boolean includeLower, boolean includeUpper) {
        return new NumericRangeFieldDataFilter<Float>(indexFieldData, lowerVal, upperVal, includeLower, includeUpper){

            @Override
            public DocIdSet getDocIdSet(AtomicReaderContext ctx, Bits acceptedDocs) throws IOException {
                float inclusiveUpperPoint;
                float inclusiveLowerPoint;
                int i;
                float f2;
                if (this.lowerVal != null) {
                    f2 = ((Float)this.lowerVal).floatValue();
                    if (!this.includeUpper && f2 > 0.0f && Float.isInfinite(f2)) {
                        return null;
                    }
                    i = NumericUtils.floatToSortableInt(f2);
                    inclusiveLowerPoint = NumericUtils.sortableIntToFloat(this.includeLower ? i : i + 1);
                } else {
                    inclusiveLowerPoint = Float.NEGATIVE_INFINITY;
                }
                if (this.upperVal != null) {
                    f2 = ((Float)this.upperVal).floatValue();
                    if (!this.includeUpper && f2 < 0.0f && Float.isInfinite(f2)) {
                        return null;
                    }
                    i = NumericUtils.floatToSortableInt(f2);
                    inclusiveUpperPoint = NumericUtils.sortableIntToFloat(this.includeUpper ? i : i - 1);
                } else {
                    inclusiveUpperPoint = Float.POSITIVE_INFINITY;
                }
                if (inclusiveLowerPoint > inclusiveUpperPoint) {
                    return null;
                }
                DoubleValues values2 = this.indexFieldData.load(ctx).getDoubleValues();
                return new DoubleRangeMatchDocIdSet(ctx.reader().maxDoc(), acceptedDocs, values2, inclusiveLowerPoint, inclusiveUpperPoint);
            }
        };
    }

    public static NumericRangeFieldDataFilter<Double> newDoubleRange(IndexNumericFieldData indexFieldData, Double lowerVal, Double upperVal, boolean includeLower, boolean includeUpper) {
        return new NumericRangeFieldDataFilter<Double>(indexFieldData, lowerVal, upperVal, includeLower, includeUpper){

            @Override
            public DocIdSet getDocIdSet(AtomicReaderContext ctx, Bits acceptedDocs) throws IOException {
                double inclusiveUpperPoint;
                double inclusiveLowerPoint;
                long i;
                double f2;
                if (this.lowerVal != null) {
                    f2 = (Double)this.lowerVal;
                    if (!this.includeUpper && f2 > 0.0 && Double.isInfinite(f2)) {
                        return null;
                    }
                    i = NumericUtils.doubleToSortableLong(f2);
                    inclusiveLowerPoint = NumericUtils.sortableLongToDouble(this.includeLower ? i : i + 1L);
                } else {
                    inclusiveLowerPoint = Double.NEGATIVE_INFINITY;
                }
                if (this.upperVal != null) {
                    f2 = (Double)this.upperVal;
                    if (!this.includeUpper && f2 < 0.0 && Double.isInfinite(f2)) {
                        return null;
                    }
                    i = NumericUtils.doubleToSortableLong(f2);
                    inclusiveUpperPoint = NumericUtils.sortableLongToDouble(this.includeUpper ? i : i - 1L);
                } else {
                    inclusiveUpperPoint = Double.POSITIVE_INFINITY;
                }
                if (inclusiveLowerPoint > inclusiveUpperPoint) {
                    return null;
                }
                DoubleValues values2 = this.indexFieldData.load(ctx).getDoubleValues();
                return new DoubleRangeMatchDocIdSet(ctx.reader().maxDoc(), acceptedDocs, values2, inclusiveLowerPoint, inclusiveUpperPoint);
            }
        };
    }

    private static final class LongRangeMatchDocIdSet
    extends MatchDocIdSet {
        private final LongValues values;
        private final long inclusiveLowerPoint;
        private final long inclusiveUpperPoint;

        protected LongRangeMatchDocIdSet(int maxDoc, Bits acceptDocs, LongValues values2, long inclusiveLowerPoint, long inclusiveUpperPoint) {
            super(maxDoc, acceptDocs);
            this.inclusiveLowerPoint = inclusiveLowerPoint;
            this.inclusiveUpperPoint = inclusiveUpperPoint;
            this.values = values2;
        }

        @Override
        public boolean isCacheable() {
            return true;
        }

        @Override
        protected boolean matchDoc(int doc) {
            int numValues = this.values.setDocument(doc);
            for (int i = 0; i < numValues; ++i) {
                long value2 = this.values.nextValue();
                if (value2 < this.inclusiveLowerPoint || value2 > this.inclusiveUpperPoint) continue;
                return true;
            }
            return false;
        }
    }

    private static final class DoubleRangeMatchDocIdSet
    extends MatchDocIdSet {
        private final DoubleValues values;
        private final double inclusiveLowerPoint;
        private final double inclusiveUpperPoint;

        protected DoubleRangeMatchDocIdSet(int maxDoc, Bits acceptDocs, DoubleValues values2, double inclusiveLowerPoint, double inclusiveUpperPoint) {
            super(maxDoc, acceptDocs);
            this.inclusiveLowerPoint = inclusiveLowerPoint;
            this.inclusiveUpperPoint = inclusiveUpperPoint;
            this.values = values2;
        }

        @Override
        public boolean isCacheable() {
            return true;
        }

        @Override
        protected boolean matchDoc(int doc) {
            int numValues = this.values.setDocument(doc);
            for (int i = 0; i < numValues; ++i) {
                double value2 = this.values.nextValue();
                if (!(value2 >= this.inclusiveLowerPoint) || !(value2 <= this.inclusiveUpperPoint)) continue;
                return true;
            }
            return false;
        }
    }
}

