/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.functionscore.random;

import java.io.IOException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.function.RandomScoreFunction;
import org.elasticsearch.common.lucene.search.function.ScoreFunction;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.functionscore.ScoreFunctionParser;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.search.internal.SearchContext;

public class RandomScoreFunctionParser
implements ScoreFunctionParser {
    public static String[] NAMES = new String[]{"random_score", "randomScore"};

    @Inject
    public RandomScoreFunctionParser() {
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }

    @Override
    public ScoreFunction parse(QueryParseContext parseContext, XContentParser parser) throws IOException, QueryParsingException {
        XContentParser.Token token2;
        long seed = -1L;
        String currentFieldName = null;
        while ((token2 = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token2 == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (!token2.isValue()) continue;
            if ("seed".equals(currentFieldName)) {
                seed = parser.longValue();
                continue;
            }
            throw new QueryParsingException(parseContext.index(), NAMES[0] + " query does not support [" + currentFieldName + "]");
        }
        if (seed == -1L) {
            seed = parseContext.nowInMillis();
        }
        ShardId shardId = SearchContext.current().indexShard().shardId();
        seed = RandomScoreFunctionParser.salt(seed, shardId.index().name(), shardId.id());
        return new RandomScoreFunction(seed);
    }

    public static long salt(long seed, String index, int shardId) {
        long salt = index.hashCode();
        salt <<= 32;
        return (salt |= (long)shardId) ^ seed;
    }
}

