/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.functionscore;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.ComplexExplanation;
import org.apache.lucene.search.Explanation;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.ElasticSearchParseException;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.lucene.search.function.CombineFunction;
import org.elasticsearch.common.lucene.search.function.ScoreFunction;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.fielddata.AtomicGeoPointFieldData;
import org.elasticsearch.index.fielddata.DoubleValues;
import org.elasticsearch.index.fielddata.GeoPointValues;
import org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.core.DateFieldMapper;
import org.elasticsearch.index.mapper.core.NumberFieldMapper;
import org.elasticsearch.index.mapper.geo.GeoPointFieldMapper;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.functionscore.DecayFunction;
import org.elasticsearch.index.query.functionscore.ScoreFunctionParser;
import org.elasticsearch.search.internal.SearchContext;

public abstract class DecayFunctionParser
implements ScoreFunctionParser {
    public abstract DecayFunction getDecayFunction();

    @Override
    public ScoreFunction parse(QueryParseContext parseContext, XContentParser parser) throws IOException, QueryParsingException {
        String currentFieldName = null;
        ScoreFunction scoreFunction = null;
        XContentParser.Token token2 = parser.nextToken();
        if (token2 == XContentParser.Token.FIELD_NAME) {
            currentFieldName = parser.currentName();
            token2 = parser.nextToken();
            if (token2 != XContentParser.Token.START_OBJECT) {
                throw new ElasticSearchParseException("Malformed score function score parameters.");
            }
        } else {
            throw new ElasticSearchParseException("Malformed score function score parameters.");
        }
        scoreFunction = this.parseVariable(currentFieldName, parser, parseContext);
        parser.nextToken();
        return scoreFunction;
    }

    private ScoreFunction parseVariable(String fieldName, XContentParser parser, QueryParseContext parseContext) throws IOException {
        MapperService.SmartNameFieldMappers smartMappers = parseContext.smartFieldMappers(fieldName);
        if (smartMappers == null || !smartMappers.hasMapper()) {
            throw new QueryParsingException(parseContext.index(), "Unknown field [" + fieldName + "]");
        }
        FieldMapper mapper = smartMappers.fieldMappers().mapper();
        if (mapper instanceof DateFieldMapper) {
            return this.parseDateVariable(fieldName, parser, parseContext, (DateFieldMapper)mapper);
        }
        if (mapper instanceof GeoPointFieldMapper) {
            return this.parseGeoVariable(fieldName, parser, parseContext, (GeoPointFieldMapper)mapper);
        }
        if (mapper instanceof NumberFieldMapper) {
            return this.parseNumberVariable(fieldName, parser, parseContext, (NumberFieldMapper)mapper);
        }
        throw new QueryParsingException(parseContext.index(), "Field " + fieldName + " is of type " + mapper.fieldType() + ", but only numeric types are supported.");
    }

    private ScoreFunction parseNumberVariable(String fieldName, XContentParser parser, QueryParseContext parseContext, NumberFieldMapper<?> mapper) throws IOException {
        XContentParser.Token token2;
        String parameterName = null;
        double scale = 0.0;
        double origin = 0.0;
        double decay = 0.5;
        double offset = 0.0;
        boolean scaleFound = false;
        boolean refFound = false;
        while ((token2 = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token2 == XContentParser.Token.FIELD_NAME) {
                parameterName = parser.currentName();
                continue;
            }
            if (parameterName.equals("scale")) {
                scale = parser.doubleValue();
                scaleFound = true;
                continue;
            }
            if (parameterName.equals("decay")) {
                decay = parser.doubleValue();
                continue;
            }
            if (parameterName.equals("origin")) {
                origin = parser.doubleValue();
                refFound = true;
                continue;
            }
            if (parameterName.equals("offset")) {
                offset = parser.doubleValue();
                continue;
            }
            throw new ElasticSearchParseException("Parameter " + parameterName + " not supported!");
        }
        if (!scaleFound || !refFound) {
            throw new ElasticSearchParseException("Both scaleand origin must be set for numeric fields.");
        }
        IndexNumericFieldData numericFieldData = (IndexNumericFieldData)parseContext.fieldData().getForField(mapper);
        return new NumericFieldDataScoreFunction(origin, scale, decay, offset, this.getDecayFunction(), numericFieldData);
    }

    private ScoreFunction parseGeoVariable(String fieldName, XContentParser parser, QueryParseContext parseContext, GeoPointFieldMapper mapper) throws IOException {
        XContentParser.Token token2;
        String parameterName = null;
        GeoPoint origin = new GeoPoint();
        String scaleString = null;
        String offsetString = "0km";
        double decay = 0.5;
        while ((token2 = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token2 == XContentParser.Token.FIELD_NAME) {
                parameterName = parser.currentName();
                continue;
            }
            if (parameterName.equals("scale")) {
                scaleString = parser.text();
                continue;
            }
            if (parameterName.equals("origin")) {
                origin = GeoPoint.parse(parser);
                continue;
            }
            if (parameterName.equals("decay")) {
                decay = parser.doubleValue();
                continue;
            }
            if (parameterName.equals("offset")) {
                offsetString = parser.text();
                continue;
            }
            throw new ElasticSearchParseException("Parameter " + parameterName + " not supported!");
        }
        if (origin == null || scaleString == null) {
            throw new ElasticSearchParseException("origin and scale must be set for geo fields.");
        }
        double scale = DistanceUnit.parse(scaleString, DistanceUnit.METERS, DistanceUnit.METERS);
        double offset = DistanceUnit.parse(offsetString, DistanceUnit.METERS, DistanceUnit.METERS);
        IndexGeoPointFieldData indexFieldData = (IndexGeoPointFieldData)parseContext.fieldData().getForField(mapper);
        return new GeoFieldDataScoreFunction(origin, scale, decay, offset, this.getDecayFunction(), indexFieldData);
    }

    private ScoreFunction parseDateVariable(String fieldName, XContentParser parser, QueryParseContext parseContext, DateFieldMapper dateFieldMapper) throws IOException {
        XContentParser.Token token2;
        String parameterName = null;
        String scaleString = null;
        String originString = null;
        String offsetString = "0d";
        double decay = 0.5;
        while ((token2 = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token2 == XContentParser.Token.FIELD_NAME) {
                parameterName = parser.currentName();
                continue;
            }
            if (parameterName.equals("scale")) {
                scaleString = parser.text();
                continue;
            }
            if (parameterName.equals("origin")) {
                originString = parser.text();
                continue;
            }
            if (parameterName.equals("decay")) {
                decay = parser.doubleValue();
                continue;
            }
            if (parameterName.equals("offset")) {
                offsetString = parser.text();
                continue;
            }
            throw new ElasticSearchParseException("Parameter " + parameterName + " not supported!");
        }
        long origin = SearchContext.current().nowInMillis();
        if (originString != null) {
            origin = dateFieldMapper.parseToMilliseconds(originString, parseContext);
        }
        if (scaleString == null) {
            throw new ElasticSearchParseException("scale must be set for date fields.");
        }
        TimeValue val = TimeValue.parseTimeValue(scaleString, TimeValue.timeValueHours(24L));
        double scale = val.getMillis();
        val = TimeValue.parseTimeValue(offsetString, TimeValue.timeValueHours(24L));
        double offset = val.getMillis();
        IndexNumericFieldData numericFieldData = (IndexNumericFieldData)parseContext.fieldData().getForField(dateFieldMapper);
        return new NumericFieldDataScoreFunction(origin, scale, decay, offset, this.getDecayFunction(), numericFieldData);
    }

    public static abstract class AbstractDistanceScoreFunction
    extends ScoreFunction {
        private final double scale;
        protected final double offset;
        private final DecayFunction func;

        public AbstractDistanceScoreFunction(double userSuppiedScale, double decay, double offset, DecayFunction func) {
            super(CombineFunction.MULT);
            if (userSuppiedScale <= 0.0) {
                throw new ElasticSearchIllegalArgumentException("function_score : scale must be > 0.0.");
            }
            if (decay <= 0.0 || decay >= 1.0) {
                throw new ElasticSearchIllegalArgumentException("function_score : decay must be in the range [0..1].");
            }
            this.scale = func.processScale(userSuppiedScale, decay);
            this.func = func;
            if (offset < 0.0) {
                throw new ElasticSearchIllegalArgumentException("function_score : offset must be > 0.0");
            }
            this.offset = offset;
        }

        @Override
        public double score(int docId, float subQueryScore) {
            double value2 = this.distance(docId);
            return this.func.evaluate(value2, this.scale);
        }

        protected abstract double distance(int var1);

        protected abstract String getDistanceString(int var1);

        protected abstract String getFieldName();

        @Override
        public Explanation explainScore(int docId, Explanation subQueryExpl) {
            ComplexExplanation ce = new ComplexExplanation();
            ce.setValue(CombineFunction.toFloat(this.score(docId, subQueryExpl.getValue())));
            ce.setMatch(true);
            ce.setDescription("Function for field " + this.getFieldName() + ":");
            ce.addDetail(this.func.explainFunction(this.getDistanceString(docId), this.distance(docId), this.scale));
            return ce;
        }
    }

    static class NumericFieldDataScoreFunction
    extends AbstractDistanceScoreFunction {
        private final IndexNumericFieldData<?> fieldData;
        private final double origin;
        private DoubleValues doubleValues;

        public NumericFieldDataScoreFunction(double origin, double scale, double decay, double offset, DecayFunction func, IndexNumericFieldData<?> fieldData) {
            super(scale, decay, offset, func);
            this.fieldData = fieldData;
            this.origin = origin;
        }

        @Override
        public void setNextReader(AtomicReaderContext context) {
            this.doubleValues = this.fieldData.load(context).getDoubleValues();
        }

        private final double getValue(int doc, double missing) {
            int i = 0;
            int num = this.doubleValues.setDocument(doc);
            if (i < num) {
                return this.doubleValues.nextValue();
            }
            return missing;
        }

        @Override
        protected double distance(int docId) {
            double distance = Math.abs(this.getValue(docId, this.origin) - this.origin) - this.offset;
            return Math.max(0.0, distance);
        }

        @Override
        protected String getDistanceString(int docId) {
            return "Math.abs(" + this.getValue(docId, this.origin) + "(=doc value) - " + this.origin + "(=origin)) - " + this.offset + "(=offset) < 0.0 ? 0.0: Math.abs(" + this.getValue(docId, this.origin) + "(=doc value) - " + this.origin + ") - " + this.offset + "(=offset)";
        }

        @Override
        protected String getFieldName() {
            return this.fieldData.getFieldNames().fullName();
        }
    }

    static class GeoFieldDataScoreFunction
    extends AbstractDistanceScoreFunction {
        private final GeoPoint origin;
        private final IndexGeoPointFieldData<?> fieldData;
        private GeoPointValues geoPointValues = null;
        private static final GeoDistance distFunction = GeoDistance.DEFAULT;

        public GeoFieldDataScoreFunction(GeoPoint origin, double scale, double decay, double offset, DecayFunction func, IndexGeoPointFieldData<?> fieldData) {
            super(scale, decay, offset, func);
            this.origin = origin;
            this.fieldData = fieldData;
        }

        @Override
        public void setNextReader(AtomicReaderContext context) {
            this.geoPointValues = ((AtomicGeoPointFieldData)this.fieldData.load(context)).getGeoPointValues();
        }

        private final GeoPoint getValue(int doc, GeoPoint missing) {
            int i = 0;
            int num = this.geoPointValues.setDocument(doc);
            if (i < num) {
                return this.geoPointValues.nextValue();
            }
            return missing;
        }

        @Override
        protected double distance(int docId) {
            GeoPoint other = this.getValue(docId, this.origin);
            double distance = Math.abs(distFunction.calculate(this.origin.lat(), this.origin.lon(), other.lat(), other.lon(), DistanceUnit.METERS)) - this.offset;
            return Math.max(0.0, distance);
        }

        @Override
        protected String getDistanceString(int docId) {
            GeoPoint other = this.getValue(docId, this.origin);
            return "arcDistance(" + other + "(=doc value), " + this.origin + "(=origin)) - " + this.offset + "(=offset) < 0.0 ? 0.0: arcDistance(" + other + "(=doc value), " + this.origin + "(=origin)) - " + this.offset + "(=offset)";
        }

        @Override
        protected String getFieldName() {
            return this.fieldData.getFieldNames().fullName();
        }
    }
}

