/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.search.Filter;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.FilterParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParsingException;

public class WrapperFilterParser
implements FilterParser {
    public static final String NAME = "wrapper";

    @Inject
    public WrapperFilterParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Filter parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser parser = parseContext.parser();
        XContentParser.Token token2 = parser.nextToken();
        if (token2 != XContentParser.Token.FIELD_NAME) {
            throw new QueryParsingException(parseContext.index(), "[wrapper] filter malformed");
        }
        String fieldName = parser.currentName();
        if (!fieldName.equals("filter")) {
            throw new QueryParsingException(parseContext.index(), "[wrapper] filter malformed");
        }
        parser.nextToken();
        byte[] querySource = parser.binaryValue();
        XContentParser qSourceParser = XContentFactory.xContent(querySource).createParser(querySource);
        try {
            QueryParseContext context = new QueryParseContext(parseContext.index(), parseContext.indexQueryParser);
            context.reset(qSourceParser);
            Filter result2 = context.parseInnerFilter();
            parser.nextToken();
            Filter filter2 = result2;
            return filter2;
        }
        finally {
            qSourceParser.close();
        }
    }
}

