/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Collection;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseQueryBuilder;
import org.elasticsearch.index.query.BoostableQueryBuilder;

public class TermsQueryBuilder
extends BaseQueryBuilder
implements BoostableQueryBuilder<TermsQueryBuilder> {
    private final String name;
    private final Object[] values;
    private String minimumShouldMatch;
    private Boolean disableCoord;
    private float boost = -1.0f;
    private String queryName;

    public TermsQueryBuilder(String name, String ... values2) {
        this(name, (Object[])values2);
    }

    public TermsQueryBuilder(String name, int ... values2) {
        this.name = name;
        this.values = new Integer[values2.length];
        for (int i = 0; i < values2.length; ++i) {
            this.values[i] = values2[i];
        }
    }

    public TermsQueryBuilder(String name, long ... values2) {
        this.name = name;
        this.values = new Long[values2.length];
        for (int i = 0; i < values2.length; ++i) {
            this.values[i] = values2[i];
        }
    }

    public TermsQueryBuilder(String name, float ... values2) {
        this.name = name;
        this.values = new Float[values2.length];
        for (int i = 0; i < values2.length; ++i) {
            this.values[i] = Float.valueOf(values2[i]);
        }
    }

    public TermsQueryBuilder(String name, double ... values2) {
        this.name = name;
        this.values = new Double[values2.length];
        for (int i = 0; i < values2.length; ++i) {
            this.values[i] = values2[i];
        }
    }

    public TermsQueryBuilder(String name, Object ... values2) {
        this.name = name;
        this.values = values2;
    }

    public TermsQueryBuilder(String name, Collection values2) {
        this(name, values2.toArray());
    }

    public TermsQueryBuilder minimumMatch(int minimumMatch) {
        this.minimumShouldMatch = Integer.toString(minimumMatch);
        return this;
    }

    public TermsQueryBuilder minimumShouldMatch(String minimumShouldMatch) {
        this.minimumShouldMatch = minimumShouldMatch;
        return this;
    }

    @Override
    public TermsQueryBuilder boost(float boost) {
        this.boost = boost;
        return this;
    }

    public TermsQueryBuilder disableCoord(boolean disableCoord) {
        this.disableCoord = disableCoord;
        return this;
    }

    public TermsQueryBuilder queryName(String queryName) {
        this.queryName = queryName;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("terms");
        builder.startArray(this.name);
        for (Object value2 : this.values) {
            builder.value(value2);
        }
        builder.endArray();
        if (this.minimumShouldMatch != null) {
            builder.field("minimum_should_match", this.minimumShouldMatch);
        }
        if (this.disableCoord != null) {
            builder.field("disable_coord", (Object)this.disableCoord);
        }
        if (this.boost != -1.0f) {
            builder.field("boost", this.boost);
        }
        if (this.queryName != null) {
            builder.field("_name", this.queryName);
        }
        builder.endObject();
    }
}

