/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseQueryBuilder;
import org.elasticsearch.index.query.BoostableQueryBuilder;
import org.elasticsearch.index.query.SpanQueryBuilder;

public class SpanOrQueryBuilder
extends BaseQueryBuilder
implements SpanQueryBuilder,
BoostableQueryBuilder<SpanOrQueryBuilder> {
    private ArrayList<SpanQueryBuilder> clauses = new ArrayList();
    private float boost = -1.0f;
    private String queryName;

    public SpanOrQueryBuilder clause(SpanQueryBuilder clause) {
        this.clauses.add(clause);
        return this;
    }

    @Override
    public SpanOrQueryBuilder boost(float boost) {
        this.boost = boost;
        return this;
    }

    public SpanOrQueryBuilder queryName(String queryName) {
        this.queryName = queryName;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.clauses.isEmpty()) {
            throw new ElasticSearchIllegalArgumentException("Must have at least one clause when building a spanOr query");
        }
        builder.startObject("span_or");
        builder.startArray("clauses");
        for (SpanQueryBuilder clause : this.clauses) {
            clause.toXContent(builder, params);
        }
        builder.endArray();
        if (this.boost != -1.0f) {
            builder.field("boost", this.boost);
        }
        if (this.queryName != null) {
            builder.field("_name", this.queryName);
        }
        builder.endObject();
    }
}

