/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseQueryBuilder;
import org.elasticsearch.index.query.BoostableQueryBuilder;
import org.elasticsearch.index.query.SpanQueryBuilder;

public class SpanNotQueryBuilder
extends BaseQueryBuilder
implements SpanQueryBuilder,
BoostableQueryBuilder<SpanNotQueryBuilder> {
    private SpanQueryBuilder include;
    private SpanQueryBuilder exclude;
    private float boost = -1.0f;
    private String queryName;

    public SpanNotQueryBuilder include(SpanQueryBuilder include) {
        this.include = include;
        return this;
    }

    public SpanNotQueryBuilder exclude(SpanQueryBuilder exclude) {
        this.exclude = exclude;
        return this;
    }

    @Override
    public SpanNotQueryBuilder boost(float boost) {
        this.boost = boost;
        return this;
    }

    public SpanNotQueryBuilder queryName(String queryName) {
        this.queryName = queryName;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.include == null) {
            throw new ElasticSearchIllegalArgumentException("Must specify include when using spanNot query");
        }
        if (this.exclude == null) {
            throw new ElasticSearchIllegalArgumentException("Must specify exclude when using spanNot query");
        }
        builder.startObject("span_not");
        builder.field("include");
        this.include.toXContent(builder, params);
        builder.field("exclude");
        this.exclude.toXContent(builder, params);
        if (this.boost != -1.0f) {
            builder.field("boost", this.boost);
        }
        if (this.queryName != null) {
            builder.field("_name", this.queryName);
        }
        builder.endObject();
    }
}

