/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spans.SpanFirstQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;

public class SpanFirstQueryParser
implements QueryParser {
    public static final String NAME = "span_first";

    @Inject
    public SpanFirstQueryParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME, Strings.toCamelCase(NAME)};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        Query query;
        XContentParser.Token token2;
        XContentParser parser = parseContext.parser();
        float boost = 1.0f;
        SpanQuery match = null;
        int end = -1;
        String queryName = null;
        String currentFieldName = null;
        while ((token2 = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token2 == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token2 == XContentParser.Token.START_OBJECT) {
                if ("match".equals(currentFieldName)) {
                    query = parseContext.parseInnerQuery();
                    if (!(query instanceof SpanQuery)) {
                        throw new QueryParsingException(parseContext.index(), "spanFirst [match] must be of type span query");
                    }
                    match = query;
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), "[span_first] query does not support [" + currentFieldName + "]");
            }
            if ("boost".equals(currentFieldName)) {
                boost = parser.floatValue();
                continue;
            }
            if ("end".equals(currentFieldName)) {
                end = parser.intValue();
                continue;
            }
            if ("_name".equals(currentFieldName)) {
                queryName = parser.text();
                continue;
            }
            throw new QueryParsingException(parseContext.index(), "[span_first] query does not support [" + currentFieldName + "]");
        }
        if (match == null) {
            throw new QueryParsingException(parseContext.index(), "spanFirst must have [match] span query clause");
        }
        if (end == -1) {
            throw new QueryParsingException(parseContext.index(), "spanFirst must have [end] set for it");
        }
        query = new SpanFirstQuery(match, end);
        query.setBoost(boost);
        if (queryName != null) {
            parseContext.addNamedQuery(queryName, query);
        }
        return query;
    }
}

