/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryparser.XSimpleQueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.SimpleQueryStringFlag;

public class SimpleQueryStringParser
implements QueryParser {
    public static final String NAME = "simple_query_string";

    @Inject
    public SimpleQueryStringParser(Settings settings) {
    }

    @Override
    public String[] names() {
        return new String[]{NAME, Strings.toCamelCase(NAME)};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token2;
        XContentParser parser = parseContext.parser();
        String currentFieldName = null;
        String queryBody = null;
        String field2 = null;
        HashMap<String, Float> fieldsAndWeights = null;
        BooleanClause.Occur defaultOperator = null;
        Analyzer analyzer = null;
        int flags = -1;
        while ((token2 = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token2 == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token2 == XContentParser.Token.START_ARRAY) {
                if ("fields".equals(currentFieldName)) {
                    while ((token2 = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        String fField = null;
                        float fBoost = 1.0f;
                        char[] text2 = parser.textCharacters();
                        int end = parser.textOffset() + parser.textLength();
                        for (int i = parser.textOffset(); i < end; ++i) {
                            if (text2[i] != '^') continue;
                            int relativeLocation = i - parser.textOffset();
                            fField = new String(text2, parser.textOffset(), relativeLocation);
                            fBoost = Float.parseFloat(new String(text2, i + 1, parser.textLength() - relativeLocation - 1));
                            break;
                        }
                        if (fField == null) {
                            fField = parser.text();
                        }
                        if (fieldsAndWeights == null) {
                            fieldsAndWeights = new HashMap<String, Float>();
                        }
                        if (Regex.isSimpleMatchPattern(fField)) {
                            for (String fieldName : parseContext.mapperService().simpleMatchToIndexNames(fField)) {
                                fieldsAndWeights.put(fieldName, Float.valueOf(fBoost));
                            }
                            continue;
                        }
                        fieldsAndWeights.put(fField, Float.valueOf(fBoost));
                    }
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), "[simple_query_string] query does not support [" + currentFieldName + "]");
            }
            if (!token2.isValue()) continue;
            if ("query".equals(currentFieldName)) {
                queryBody = parser.text();
                continue;
            }
            if ("analyzer".equals(currentFieldName)) {
                analyzer = parseContext.analysisService().analyzer(parser.text());
                if (analyzer != null) continue;
                throw new QueryParsingException(parseContext.index(), "[simple_query_string] analyzer [" + parser.text() + "] not found");
            }
            if ("field".equals(currentFieldName)) {
                field2 = parser.text();
                continue;
            }
            if ("default_operator".equals(currentFieldName)) {
                String op = parser.text();
                if ("or".equalsIgnoreCase(op)) {
                    defaultOperator = BooleanClause.Occur.SHOULD;
                    continue;
                }
                if ("and".equalsIgnoreCase(op)) {
                    defaultOperator = BooleanClause.Occur.MUST;
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), "[simple_query_string] default operator [" + op + "] is not allowed");
            }
            if ("flags".equals(currentFieldName)) {
                if (parser.hasTextCharacters()) {
                    flags = SimpleQueryStringFlag.resolveFlags(parser.text());
                    continue;
                }
                flags = parser.intValue();
                if (flags >= 0) continue;
                flags = SimpleQueryStringFlag.ALL.value();
                continue;
            }
            throw new QueryParsingException(parseContext.index(), "[simple_query_string] unsupported field [" + parser.currentName() + "]");
        }
        if (queryBody == null) {
            throw new QueryParsingException(parseContext.index(), "[simple_query_string] query text missing");
        }
        if (field2 == null) {
            field2 = currentFieldName;
        }
        if (fieldsAndWeights == null) {
            field2 = parseContext.defaultField();
        }
        if (analyzer == null) {
            analyzer = parseContext.mapperService().searchAnalyzer();
        }
        XSimpleQueryParser sqp = fieldsAndWeights != null ? new XSimpleQueryParser(analyzer, fieldsAndWeights, flags) : new XSimpleQueryParser(analyzer, Collections.singletonMap(field2, Float.valueOf(1.0f)), flags);
        if (defaultOperator != null) {
            sqp.setDefaultOperator(defaultOperator);
        }
        return sqp.parse(queryBody);
    }
}

