/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.util.Locale;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.Strings;

public enum SimpleQueryStringFlag {
    ALL(-1),
    NONE(0),
    AND(1),
    NOT(2),
    OR(4),
    PREFIX(8),
    PRECEDENCE(32),
    ESCAPE(64),
    WHITESPACE(128);

    final int value;

    private SimpleQueryStringFlag(int value2) {
        this.value = value2;
    }

    public int value() {
        return this.value;
    }

    static int resolveFlags(String flags) {
        if (!Strings.hasLength(flags)) {
            return ALL.value();
        }
        int magic = NONE.value();
        for (String s : Strings.delimitedListToStringArray(flags, "|")) {
            if (s.isEmpty()) continue;
            try {
                SimpleQueryStringFlag flag = SimpleQueryStringFlag.valueOf(s.toUpperCase(Locale.ROOT));
                switch (flag) {
                    case NONE: {
                        return 0;
                    }
                    case ALL: {
                        return -1;
                    }
                }
                magic |= flag.value();
            }
            catch (IllegalArgumentException iae) {
                throw new ElasticSearchIllegalArgumentException("Unknown simple_query_string flag [" + s + "]");
            }
        }
        return magic;
    }
}

