/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseQueryBuilder;
import org.elasticsearch.index.query.SimpleQueryStringFlag;

public class SimpleQueryStringBuilder
extends BaseQueryBuilder {
    private Map<String, Float> fields = new HashMap<String, Float>();
    private String analyzer;
    private Operator operator;
    private final String queryText;
    private int flags = -1;

    public SimpleQueryStringBuilder(String text2) {
        this.queryText = text2;
    }

    public SimpleQueryStringBuilder field(String field2) {
        this.fields.put(field2, null);
        return this;
    }

    public SimpleQueryStringBuilder field(String field2, float boost) {
        this.fields.put(field2, Float.valueOf(boost));
        return this;
    }

    public SimpleQueryStringBuilder analyzer(String analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    public SimpleQueryStringBuilder defaultOperator(Operator defaultOperator) {
        this.operator = defaultOperator;
        return this;
    }

    public SimpleQueryStringBuilder flags(SimpleQueryStringFlag ... flags) {
        int value2 = 0;
        if (flags.length == 0) {
            value2 = SimpleQueryStringFlag.ALL.value;
        } else {
            for (SimpleQueryStringFlag flag : flags) {
                value2 |= flag.value;
            }
        }
        this.flags = value2;
        return this;
    }

    @Override
    public void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("simple_query_string");
        builder.field("query", this.queryText);
        if (this.fields.size() > 0) {
            builder.startArray("fields");
            for (Map.Entry<String, Float> entry2 : this.fields.entrySet()) {
                String field2 = entry2.getKey();
                Float boost = entry2.getValue();
                if (boost != null) {
                    builder.value(field2 + "^" + boost);
                    continue;
                }
                builder.value(field2);
            }
            builder.endArray();
        }
        if (this.flags != -1) {
            builder.field("flags", this.flags);
        }
        if (this.analyzer != null) {
            builder.field("analyzer", this.analyzer);
        }
        if (this.operator != null) {
            builder.field("default_operator", this.operator.name().toLowerCase(Locale.ROOT));
        }
        builder.endObject();
    }

    public static enum Operator {
        AND,
        OR;

    }
}

