/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseFilterBuilder;

public class ScriptFilterBuilder
extends BaseFilterBuilder {
    private final String script;
    private Map<String, Object> params;
    private String lang;
    private Boolean cache;
    private String cacheKey;
    private String filterName;

    public ScriptFilterBuilder(String script) {
        this.script = script;
    }

    public ScriptFilterBuilder addParam(String name, Object value2) {
        if (this.params == null) {
            this.params = Maps.newHashMap();
        }
        this.params.put(name, value2);
        return this;
    }

    public ScriptFilterBuilder params(Map<String, Object> params) {
        if (this.params == null) {
            this.params = params;
        } else {
            this.params.putAll(params);
        }
        return this;
    }

    public ScriptFilterBuilder lang(String lang) {
        this.lang = lang;
        return this;
    }

    public ScriptFilterBuilder filterName(String filterName) {
        this.filterName = filterName;
        return this;
    }

    public ScriptFilterBuilder cache(boolean cache) {
        this.cache = cache;
        return this;
    }

    public ScriptFilterBuilder cacheKey(String cacheKey) {
        this.cacheKey = cacheKey;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("script");
        builder.field("script", this.script);
        if (this.params != null) {
            builder.field("params", this.params);
        }
        if (this.lang != null) {
            builder.field("lang", this.lang);
        }
        if (this.filterName != null) {
            builder.field("_name", this.filterName);
        }
        if (this.cache != null) {
            builder.field("_cache", (Object)this.cache);
        }
        if (this.cacheKey != null) {
            builder.field("_cache_key", this.cacheKey);
        }
        builder.endObject();
    }
}

