/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Filter;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.lucene.search.RegexpFilter;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.cache.filter.support.CacheKeyFilter;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.FilterParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.RegexpFlag;
import org.elasticsearch.index.query.support.QueryParsers;

public class RegexpFilterParser
implements FilterParser {
    public static final String NAME = "regexp";

    @Inject
    public RegexpFilterParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Filter parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token2;
        XContentParser parser = parseContext.parser();
        boolean cache = true;
        CacheKeyFilter.Key cacheKey = null;
        String fieldName = null;
        String secondaryFieldName = null;
        Object value2 = null;
        Object secondaryValue = null;
        int flagsValue = -1;
        String filterName = null;
        String currentFieldName = null;
        while ((token2 = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token2 == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token2 == XContentParser.Token.START_OBJECT) {
                fieldName = currentFieldName;
                while ((token2 = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token2 == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if ("value".equals(currentFieldName)) {
                        value2 = parser.objectBytes();
                        continue;
                    }
                    if ("flags".equals(currentFieldName)) {
                        String flags = parser.textOrNull();
                        flagsValue = RegexpFlag.resolveValue(flags);
                        continue;
                    }
                    if ("flags_value".equals(currentFieldName)) {
                        flagsValue = parser.intValue();
                        continue;
                    }
                    throw new QueryParsingException(parseContext.index(), "[regexp] filter does not support [" + currentFieldName + "]");
                }
                continue;
            }
            if ("_name".equals(currentFieldName)) {
                filterName = parser.text();
                continue;
            }
            if ("_cache".equals(currentFieldName)) {
                cache = parser.booleanValue();
                continue;
            }
            if ("_cache_key".equals(currentFieldName) || "_cacheKey".equals(currentFieldName)) {
                cacheKey = new CacheKeyFilter.Key(parser.text());
                continue;
            }
            secondaryFieldName = currentFieldName;
            secondaryValue = parser.objectBytes();
        }
        if (fieldName == null) {
            fieldName = secondaryFieldName;
            value2 = secondaryValue;
        }
        if (value2 == null) {
            throw new QueryParsingException(parseContext.index(), "No value specified for regexp filter");
        }
        Filter filter2 = null;
        MapperService.SmartNameFieldMappers smartNameFieldMappers = parseContext.smartFieldMappers(fieldName);
        if (smartNameFieldMappers != null && smartNameFieldMappers.hasMapper()) {
            if (smartNameFieldMappers.explicitTypeInNameWithDocMapper()) {
                String[] previousTypes = QueryParseContext.setTypesWithPrevious(new String[]{smartNameFieldMappers.docMapper().type()});
                try {
                    filter2 = smartNameFieldMappers.mapper().regexpFilter(value2, flagsValue, parseContext);
                }
                finally {
                    QueryParseContext.setTypes(previousTypes);
                }
            } else {
                filter2 = smartNameFieldMappers.mapper().regexpFilter(value2, flagsValue, parseContext);
            }
        }
        if (filter2 == null) {
            filter2 = new RegexpFilter(new Term(fieldName, BytesRefs.toBytesRef(value2)), flagsValue);
        }
        if (cache) {
            filter2 = parseContext.cacheFilter(filter2, cacheKey);
        }
        filter2 = QueryParsers.wrapSmartNameFilter(filter2, smartNameFieldMappers, parseContext);
        if (filterName != null) {
            parseContext.addNamedFilter(filterName, filter2);
        }
        return filter2;
    }
}

