/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseQueryBuilder;
import org.elasticsearch.index.query.BoostableQueryBuilder;
import org.elasticsearch.index.query.MultiTermQueryBuilder;

public class RangeQueryBuilder
extends BaseQueryBuilder
implements MultiTermQueryBuilder,
BoostableQueryBuilder<RangeQueryBuilder> {
    private final String name;
    private Object from;
    private Object to;
    private boolean includeLower = true;
    private boolean includeUpper = true;
    private float boost = -1.0f;
    private String queryName;

    public RangeQueryBuilder(String name) {
        this.name = name;
    }

    public RangeQueryBuilder from(Object from2) {
        this.from = from2;
        return this;
    }

    public RangeQueryBuilder from(String from2) {
        this.from = from2;
        return this;
    }

    public RangeQueryBuilder from(int from2) {
        this.from = from2;
        return this;
    }

    public RangeQueryBuilder from(long from2) {
        this.from = from2;
        return this;
    }

    public RangeQueryBuilder from(float from2) {
        this.from = Float.valueOf(from2);
        return this;
    }

    public RangeQueryBuilder from(double from2) {
        this.from = from2;
        return this;
    }

    public RangeQueryBuilder gt(String from2) {
        this.from = from2;
        this.includeLower = false;
        return this;
    }

    public RangeQueryBuilder gt(Object from2) {
        this.from = from2;
        this.includeLower = false;
        return this;
    }

    public RangeQueryBuilder gt(int from2) {
        this.from = from2;
        this.includeLower = false;
        return this;
    }

    public RangeQueryBuilder gt(long from2) {
        this.from = from2;
        this.includeLower = false;
        return this;
    }

    public RangeQueryBuilder gt(float from2) {
        this.from = Float.valueOf(from2);
        this.includeLower = false;
        return this;
    }

    public RangeQueryBuilder gt(double from2) {
        this.from = from2;
        this.includeLower = false;
        return this;
    }

    public RangeQueryBuilder gte(String from2) {
        this.from = from2;
        this.includeLower = true;
        return this;
    }

    public RangeQueryBuilder gte(Object from2) {
        this.from = from2;
        this.includeLower = true;
        return this;
    }

    public RangeQueryBuilder gte(int from2) {
        this.from = from2;
        this.includeLower = true;
        return this;
    }

    public RangeQueryBuilder gte(long from2) {
        this.from = from2;
        this.includeLower = true;
        return this;
    }

    public RangeQueryBuilder gte(float from2) {
        this.from = Float.valueOf(from2);
        this.includeLower = true;
        return this;
    }

    public RangeQueryBuilder gte(double from2) {
        this.from = from2;
        this.includeLower = true;
        return this;
    }

    public RangeQueryBuilder to(Object to2) {
        this.to = to2;
        return this;
    }

    public RangeQueryBuilder to(String to2) {
        this.to = to2;
        return this;
    }

    public RangeQueryBuilder to(int to2) {
        this.to = to2;
        return this;
    }

    public RangeQueryBuilder to(long to2) {
        this.to = to2;
        return this;
    }

    public RangeQueryBuilder to(float to2) {
        this.to = Float.valueOf(to2);
        return this;
    }

    public RangeQueryBuilder to(double to2) {
        this.to = to2;
        return this;
    }

    public RangeQueryBuilder lt(String to2) {
        this.to = to2;
        this.includeUpper = false;
        return this;
    }

    public RangeQueryBuilder lt(Object to2) {
        this.to = to2;
        this.includeUpper = false;
        return this;
    }

    public RangeQueryBuilder lt(int to2) {
        this.to = to2;
        this.includeUpper = false;
        return this;
    }

    public RangeQueryBuilder lt(long to2) {
        this.to = to2;
        this.includeUpper = false;
        return this;
    }

    public RangeQueryBuilder lt(float to2) {
        this.to = Float.valueOf(to2);
        this.includeUpper = false;
        return this;
    }

    public RangeQueryBuilder lt(double to2) {
        this.to = to2;
        this.includeUpper = false;
        return this;
    }

    public RangeQueryBuilder lte(String to2) {
        this.to = to2;
        this.includeUpper = true;
        return this;
    }

    public RangeQueryBuilder lte(Object to2) {
        this.to = to2;
        this.includeUpper = true;
        return this;
    }

    public RangeQueryBuilder lte(int to2) {
        this.to = to2;
        this.includeUpper = true;
        return this;
    }

    public RangeQueryBuilder lte(long to2) {
        this.to = to2;
        this.includeUpper = true;
        return this;
    }

    public RangeQueryBuilder lte(float to2) {
        this.to = Float.valueOf(to2);
        this.includeUpper = true;
        return this;
    }

    public RangeQueryBuilder lte(double to2) {
        this.to = to2;
        this.includeUpper = true;
        return this;
    }

    public RangeQueryBuilder includeLower(boolean includeLower) {
        this.includeLower = includeLower;
        return this;
    }

    public RangeQueryBuilder includeUpper(boolean includeUpper) {
        this.includeUpper = includeUpper;
        return this;
    }

    @Override
    public RangeQueryBuilder boost(float boost) {
        this.boost = boost;
        return this;
    }

    public RangeQueryBuilder queryName(String queryName) {
        this.queryName = queryName;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("range");
        builder.startObject(this.name);
        builder.field("from", this.from);
        builder.field("to", this.to);
        builder.field("include_lower", this.includeLower);
        builder.field("include_upper", this.includeUpper);
        if (this.boost != -1.0f) {
            builder.field("boost", this.boost);
        }
        if (this.queryName != null) {
            builder.field("_name", this.queryName);
        }
        builder.endObject();
        builder.endObject();
    }
}

