/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.TermRangeFilter;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.cache.filter.support.CacheKeyFilter;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.core.NumberFieldMapper;
import org.elasticsearch.index.query.FilterParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.support.QueryParsers;

public class RangeFilterParser
implements FilterParser {
    public static final String NAME = "range";

    @Inject
    public RangeFilterParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME};
    }

    @Override
    public Filter parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token2;
        XContentParser parser = parseContext.parser();
        Boolean cache = null;
        CacheKeyFilter.Key cacheKey = null;
        String fieldName = null;
        Object from2 = null;
        Object to2 = null;
        boolean includeLower = true;
        boolean includeUpper = true;
        String execution = "index";
        String filterName = null;
        String currentFieldName = null;
        while ((token2 = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token2 == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token2 == XContentParser.Token.START_OBJECT) {
                fieldName = currentFieldName;
                while ((token2 = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token2 == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if ("from".equals(currentFieldName)) {
                        from2 = parser.objectBytes();
                        continue;
                    }
                    if ("to".equals(currentFieldName)) {
                        to2 = parser.objectBytes();
                        continue;
                    }
                    if ("include_lower".equals(currentFieldName) || "includeLower".equals(currentFieldName)) {
                        includeLower = parser.booleanValue();
                        continue;
                    }
                    if ("include_upper".equals(currentFieldName) || "includeUpper".equals(currentFieldName)) {
                        includeUpper = parser.booleanValue();
                        continue;
                    }
                    if ("gt".equals(currentFieldName)) {
                        from2 = parser.objectBytes();
                        includeLower = false;
                        continue;
                    }
                    if ("gte".equals(currentFieldName) || "ge".equals(currentFieldName)) {
                        from2 = parser.objectBytes();
                        includeLower = true;
                        continue;
                    }
                    if ("lt".equals(currentFieldName)) {
                        to2 = parser.objectBytes();
                        includeUpper = false;
                        continue;
                    }
                    if ("lte".equals(currentFieldName) || "le".equals(currentFieldName)) {
                        to2 = parser.objectBytes();
                        includeUpper = true;
                        continue;
                    }
                    throw new QueryParsingException(parseContext.index(), "[range] filter does not support [" + currentFieldName + "]");
                }
                continue;
            }
            if (!token2.isValue()) continue;
            if ("_name".equals(currentFieldName)) {
                filterName = parser.text();
                continue;
            }
            if ("_cache".equals(currentFieldName)) {
                cache = parser.booleanValue();
                continue;
            }
            if ("_cache_key".equals(currentFieldName) || "_cacheKey".equals(currentFieldName)) {
                cacheKey = new CacheKeyFilter.Key(parser.text());
                continue;
            }
            if ("execution".equals(currentFieldName)) {
                execution = parser.text();
                continue;
            }
            throw new QueryParsingException(parseContext.index(), "[range] filter does not support [" + currentFieldName + "]");
        }
        if (fieldName == null) {
            throw new QueryParsingException(parseContext.index(), "[range] filter no field specified for range filter");
        }
        Filter filter2 = null;
        MapperService.SmartNameFieldMappers smartNameFieldMappers = parseContext.smartFieldMappers(fieldName);
        if (smartNameFieldMappers != null && smartNameFieldMappers.hasMapper()) {
            if (execution.equals("index")) {
                if (cache == null) {
                    cache = true;
                }
                filter2 = smartNameFieldMappers.mapper().rangeFilter(from2, to2, includeLower, includeUpper, parseContext);
            } else if ("fielddata".equals(execution)) {
                FieldMapper mapper;
                if (cache == null) {
                    cache = false;
                }
                if (!((mapper = smartNameFieldMappers.mapper()) instanceof NumberFieldMapper)) {
                    throw new QueryParsingException(parseContext.index(), "[range] filter field [" + fieldName + "] is not a numeric type");
                }
                filter2 = ((NumberFieldMapper)mapper).rangeFilter(parseContext.fieldData(), from2, to2, includeLower, includeUpper, parseContext);
            } else {
                throw new QueryParsingException(parseContext.index(), "[range] filter doesn't support [" + execution + "] execution");
            }
        }
        if (filter2 == null) {
            if (cache == null) {
                cache = true;
            }
            filter2 = new TermRangeFilter(fieldName, BytesRefs.toBytesRef(from2), BytesRefs.toBytesRef(to2), includeLower, includeUpper);
        }
        if (cache.booleanValue()) {
            filter2 = parseContext.cacheFilter(filter2, cacheKey);
        }
        filter2 = QueryParsers.wrapSmartNameFilter(filter2, smartNameFieldMappers, parseContext);
        if (filterName != null) {
            parseContext.addNamedFilter(filterName, filter2);
        }
        return filter2;
    }
}

