/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseFilterBuilder;

public class RangeFilterBuilder
extends BaseFilterBuilder {
    private final String name;
    private Object from;
    private Object to;
    private boolean includeLower = true;
    private boolean includeUpper = true;
    private Boolean cache;
    private String cacheKey;
    private String filterName;
    private String execution;

    public RangeFilterBuilder(String name) {
        this.name = name;
    }

    public RangeFilterBuilder from(Object from2) {
        this.from = from2;
        return this;
    }

    public RangeFilterBuilder from(int from2) {
        this.from = from2;
        return this;
    }

    public RangeFilterBuilder from(long from2) {
        this.from = from2;
        return this;
    }

    public RangeFilterBuilder from(float from2) {
        this.from = Float.valueOf(from2);
        return this;
    }

    public RangeFilterBuilder from(double from2) {
        this.from = from2;
        return this;
    }

    public RangeFilterBuilder gt(Object from2) {
        this.from = from2;
        this.includeLower = false;
        return this;
    }

    public RangeFilterBuilder gt(int from2) {
        this.from = from2;
        this.includeLower = false;
        return this;
    }

    public RangeFilterBuilder gt(long from2) {
        this.from = from2;
        this.includeLower = false;
        return this;
    }

    public RangeFilterBuilder gt(float from2) {
        this.from = Float.valueOf(from2);
        this.includeLower = false;
        return this;
    }

    public RangeFilterBuilder gt(double from2) {
        this.from = from2;
        this.includeLower = false;
        return this;
    }

    public RangeFilterBuilder gte(Object from2) {
        this.from = from2;
        this.includeLower = true;
        return this;
    }

    public RangeFilterBuilder gte(int from2) {
        this.from = from2;
        this.includeLower = true;
        return this;
    }

    public RangeFilterBuilder gte(long from2) {
        this.from = from2;
        this.includeLower = true;
        return this;
    }

    public RangeFilterBuilder gte(float from2) {
        this.from = Float.valueOf(from2);
        this.includeLower = true;
        return this;
    }

    public RangeFilterBuilder gte(double from2) {
        this.from = from2;
        this.includeLower = true;
        return this;
    }

    public RangeFilterBuilder to(Object to2) {
        this.to = to2;
        return this;
    }

    public RangeFilterBuilder to(int to2) {
        this.to = to2;
        return this;
    }

    public RangeFilterBuilder to(long to2) {
        this.to = to2;
        return this;
    }

    public RangeFilterBuilder to(float to2) {
        this.to = Float.valueOf(to2);
        return this;
    }

    public RangeFilterBuilder to(double to2) {
        this.to = to2;
        return this;
    }

    public RangeFilterBuilder lt(Object to2) {
        this.to = to2;
        this.includeUpper = false;
        return this;
    }

    public RangeFilterBuilder lt(int to2) {
        this.to = to2;
        this.includeUpper = false;
        return this;
    }

    public RangeFilterBuilder lt(long to2) {
        this.to = to2;
        this.includeUpper = false;
        return this;
    }

    public RangeFilterBuilder lt(float to2) {
        this.to = Float.valueOf(to2);
        this.includeUpper = false;
        return this;
    }

    public RangeFilterBuilder lt(double to2) {
        this.to = to2;
        this.includeUpper = false;
        return this;
    }

    public RangeFilterBuilder lte(int to2) {
        this.to = to2;
        this.includeUpper = true;
        return this;
    }

    public RangeFilterBuilder lte(long to2) {
        this.to = to2;
        this.includeUpper = true;
        return this;
    }

    public RangeFilterBuilder lte(float to2) {
        this.to = Float.valueOf(to2);
        this.includeUpper = true;
        return this;
    }

    public RangeFilterBuilder lte(double to2) {
        this.to = to2;
        this.includeUpper = true;
        return this;
    }

    public RangeFilterBuilder lte(Object to2) {
        this.to = to2;
        this.includeUpper = true;
        return this;
    }

    public RangeFilterBuilder includeLower(boolean includeLower) {
        this.includeLower = includeLower;
        return this;
    }

    public RangeFilterBuilder includeUpper(boolean includeUpper) {
        this.includeUpper = includeUpper;
        return this;
    }

    public RangeFilterBuilder filterName(String filterName) {
        this.filterName = filterName;
        return this;
    }

    public RangeFilterBuilder cache(boolean cache) {
        this.cache = cache;
        return this;
    }

    public RangeFilterBuilder cacheKey(String cacheKey) {
        this.cacheKey = cacheKey;
        return this;
    }

    public RangeFilterBuilder setExecution(String execution) {
        this.execution = execution;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("range");
        builder.startObject(this.name);
        builder.field("from", this.from);
        builder.field("to", this.to);
        builder.field("include_lower", this.includeLower);
        builder.field("include_upper", this.includeUpper);
        builder.endObject();
        if (this.filterName != null) {
            builder.field("_name", this.filterName);
        }
        if (this.cache != null) {
            builder.field("_cache", (Object)this.cache);
        }
        if (this.cacheKey != null) {
            builder.field("_cache_key", this.cacheKey);
        }
        if (this.execution != null) {
            builder.field("execution", this.execution);
        }
        builder.endObject();
    }
}

