/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.search.Filter;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.OrFilter;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.cache.filter.support.CacheKeyFilter;
import org.elasticsearch.index.query.FilterParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParsingException;

public class OrFilterParser
implements FilterParser {
    public static final String NAME = "or";

    @Inject
    public OrFilterParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME};
    }

    @Override
    public Filter parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        Filter filter2;
        XContentParser parser = parseContext.parser();
        ArrayList<Filter> filters = Lists.newArrayList();
        boolean filtersFound = false;
        boolean cache = false;
        CacheKeyFilter.Key cacheKey = null;
        String filterName = null;
        String currentFieldName = null;
        XContentParser.Token token2 = parser.currentToken();
        if (token2 == XContentParser.Token.START_ARRAY) {
            while ((token2 = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                filtersFound = true;
                filter2 = parseContext.parseInnerFilter();
                if (filter2 == null) continue;
                filters.add(filter2);
            }
        } else {
            while ((token2 = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token2 == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token2 == XContentParser.Token.START_ARRAY) {
                    if ("filters".equals(currentFieldName)) {
                        filtersFound = true;
                        while ((token2 = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                            filter2 = parseContext.parseInnerFilter();
                            if (filter2 == null) continue;
                            filters.add(filter2);
                        }
                        continue;
                    }
                    while ((token2 = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        filtersFound = true;
                        filter2 = parseContext.parseInnerFilter();
                        if (filter2 == null) continue;
                        filters.add(filter2);
                    }
                    continue;
                }
                if (!token2.isValue()) continue;
                if ("_cache".equals(currentFieldName)) {
                    cache = parser.booleanValue();
                    continue;
                }
                if ("_name".equals(currentFieldName)) {
                    filterName = parser.text();
                    continue;
                }
                if ("_cache_key".equals(currentFieldName) || "_cacheKey".equals(currentFieldName)) {
                    cacheKey = new CacheKeyFilter.Key(parser.text());
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), "[or] filter does not support [" + currentFieldName + "]");
            }
        }
        if (!filtersFound) {
            throw new QueryParsingException(parseContext.index(), "[or] filter requires 'filters' to be set on it'");
        }
        if (filters.isEmpty()) {
            return null;
        }
        filter2 = new OrFilter(filters);
        if (cache) {
            filter2 = parseContext.cacheFilter(filter2, cacheKey);
        }
        if (filterName != null) {
            parseContext.addNamedFilter(filterName, filter2);
        }
        return filter2;
    }
}

