/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.search.Filter;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.NotFilter;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.cache.filter.support.CacheKeyFilter;
import org.elasticsearch.index.query.FilterParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParsingException;

public class NotFilterParser
implements FilterParser {
    public static final String NAME = "not";

    @Inject
    public NotFilterParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME};
    }

    @Override
    public Filter parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token2;
        XContentParser parser = parseContext.parser();
        Filter filter2 = null;
        boolean filterFound = false;
        boolean cache = false;
        CacheKeyFilter.Key cacheKey = null;
        String filterName = null;
        String currentFieldName = null;
        while ((token2 = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token2 == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token2 == XContentParser.Token.START_OBJECT) {
                if ("filter".equals(currentFieldName)) {
                    filter2 = parseContext.parseInnerFilter();
                    filterFound = true;
                    continue;
                }
                filterFound = true;
                filter2 = parseContext.parseInnerFilter(currentFieldName);
                continue;
            }
            if (token2 == XContentParser.Token.START_ARRAY) {
                filterFound = true;
                filter2 = parseContext.parseInnerFilter(currentFieldName);
                continue;
            }
            if (!token2.isValue()) continue;
            if ("_cache".equals(currentFieldName)) {
                cache = parser.booleanValue();
                continue;
            }
            if ("_name".equals(currentFieldName)) {
                filterName = parser.text();
                continue;
            }
            if ("_cache_key".equals(currentFieldName) || "_cacheKey".equals(currentFieldName)) {
                cacheKey = new CacheKeyFilter.Key(parser.text());
                continue;
            }
            throw new QueryParsingException(parseContext.index(), "[not] filter does not support [" + currentFieldName + "]");
        }
        if (!filterFound) {
            throw new QueryParsingException(parseContext.index(), "filter is required when using `not` filter");
        }
        if (filter2 == null) {
            return null;
        }
        Filter notFilter = new NotFilter(filter2);
        if (cache) {
            notFilter = parseContext.cacheFilter(notFilter, cacheKey);
        }
        if (filterName != null) {
            parseContext.addNamedFilter(filterName, notFilter);
        }
        return notFilter;
    }
}

