/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.AbstractList;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.Query;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.MoreLikeThisQuery;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.analysis.Analysis;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;

public class MoreLikeThisQueryParser
implements QueryParser {
    public static final String NAME = "mlt";

    @Inject
    public MoreLikeThisQueryParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME, "more_like_this", "moreLikeThis"};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token2;
        XContentParser parser = parseContext.parser();
        MoreLikeThisQuery mltQuery = new MoreLikeThisQuery();
        mltQuery.setSimilarity(parseContext.searchSimilarity());
        Analyzer analyzer = null;
        AbstractList moreLikeFields = null;
        boolean failOnUnsupportedField = true;
        String queryName = null;
        String currentFieldName = null;
        while ((token2 = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token2 == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token2.isValue()) {
                if ("like_text".equals(currentFieldName) || "likeText".equals(currentFieldName)) {
                    mltQuery.setLikeText(parser.text());
                    continue;
                }
                if ("min_term_freq".equals(currentFieldName) || "minTermFreq".equals(currentFieldName)) {
                    mltQuery.setMinTermFrequency(parser.intValue());
                    continue;
                }
                if ("max_query_terms".equals(currentFieldName) || "maxQueryTerms".equals(currentFieldName)) {
                    mltQuery.setMaxQueryTerms(parser.intValue());
                    continue;
                }
                if ("min_doc_freq".equals(currentFieldName) || "minDocFreq".equals(currentFieldName)) {
                    mltQuery.setMinDocFreq(parser.intValue());
                    continue;
                }
                if ("max_doc_freq".equals(currentFieldName) || "maxDocFreq".equals(currentFieldName)) {
                    mltQuery.setMaxDocFreq(parser.intValue());
                    continue;
                }
                if ("min_word_len".equals(currentFieldName) || "minWordLen".equals(currentFieldName)) {
                    mltQuery.setMinWordLen(parser.intValue());
                    continue;
                }
                if ("max_word_len".equals(currentFieldName) || "maxWordLen".equals(currentFieldName)) {
                    mltQuery.setMaxWordLen(parser.intValue());
                    continue;
                }
                if ("boost_terms".equals(currentFieldName) || "boostTerms".equals(currentFieldName)) {
                    mltQuery.setBoostTerms(true);
                    mltQuery.setBoostTermsFactor(parser.floatValue());
                    continue;
                }
                if ("percent_terms_to_match".equals(currentFieldName) || "percentTermsToMatch".equals(currentFieldName)) {
                    mltQuery.setPercentTermsToMatch(parser.floatValue());
                    continue;
                }
                if ("analyzer".equals(currentFieldName)) {
                    analyzer = parseContext.analysisService().analyzer(parser.text());
                    continue;
                }
                if ("boost".equals(currentFieldName)) {
                    mltQuery.setBoost(parser.floatValue());
                    continue;
                }
                if ("fail_on_unsupported_field".equals(currentFieldName) || "failOnUnsupportedField".equals(currentFieldName)) {
                    failOnUnsupportedField = parser.booleanValue();
                    continue;
                }
                if ("_name".equals(currentFieldName)) {
                    queryName = parser.text();
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), "[mlt] query does not support [" + currentFieldName + "]");
            }
            if (token2 != XContentParser.Token.START_ARRAY) continue;
            if ("stop_words".equals(currentFieldName) || "stopWords".equals(currentFieldName)) {
                HashSet<String> stopWords = Sets.newHashSet();
                while ((token2 = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    stopWords.add(parser.text());
                }
                mltQuery.setStopWords(stopWords);
                continue;
            }
            if ("fields".equals(currentFieldName)) {
                moreLikeFields = Lists.newLinkedList();
                while ((token2 = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    moreLikeFields.add(parseContext.indexName(parser.text()));
                }
                continue;
            }
            throw new QueryParsingException(parseContext.index(), "[mlt] query does not support [" + currentFieldName + "]");
        }
        if (mltQuery.getLikeText() == null) {
            throw new QueryParsingException(parseContext.index(), "more_like_this requires 'like_text' to be specified");
        }
        if (analyzer == null) {
            analyzer = parseContext.mapperService().searchAnalyzer();
        }
        mltQuery.setAnalyzer(analyzer);
        if (moreLikeFields == null) {
            moreLikeFields = Lists.newArrayList(parseContext.defaultField());
        } else if (moreLikeFields.isEmpty()) {
            throw new QueryParsingException(parseContext.index(), "more_like_this requires 'fields' to be non-empty");
        }
        Iterator it = moreLikeFields.iterator();
        while (it.hasNext()) {
            String fieldName = (String)it.next();
            if (Analysis.generatesCharacterTokenStream(analyzer, fieldName)) continue;
            if (failOnUnsupportedField) {
                throw new ElasticSearchIllegalArgumentException("more_like_this doesn't support binary/numeric fields: [" + fieldName + "]");
            }
            it.remove();
        }
        if (moreLikeFields.isEmpty()) {
            return null;
        }
        mltQuery.setMoreLikeFields(moreLikeFields.toArray(Strings.EMPTY_ARRAY));
        if (queryName != null) {
            parseContext.addNamedQuery(queryName, mltQuery);
        }
        return mltQuery;
    }
}

