/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseQueryBuilder;
import org.elasticsearch.index.query.BoostableQueryBuilder;

public class MoreLikeThisFieldQueryBuilder
extends BaseQueryBuilder
implements BoostableQueryBuilder<MoreLikeThisFieldQueryBuilder> {
    private final String name;
    private String likeText;
    private float percentTermsToMatch = -1.0f;
    private int minTermFreq = -1;
    private int maxQueryTerms = -1;
    private String[] stopWords = null;
    private int minDocFreq = -1;
    private int maxDocFreq = -1;
    private int minWordLen = -1;
    private int maxWordLen = -1;
    private float boostTerms = -1.0f;
    private float boost = -1.0f;
    private String analyzer;
    private Boolean failOnUnsupportedField;
    private String queryName;

    public MoreLikeThisFieldQueryBuilder(String name) {
        this.name = name;
    }

    public MoreLikeThisFieldQueryBuilder likeText(String likeText) {
        this.likeText = likeText;
        return this;
    }

    public MoreLikeThisFieldQueryBuilder percentTermsToMatch(float percentTermsToMatch) {
        this.percentTermsToMatch = percentTermsToMatch;
        return this;
    }

    public MoreLikeThisFieldQueryBuilder minTermFreq(int minTermFreqy) {
        this.minTermFreq = minTermFreqy;
        return this;
    }

    public MoreLikeThisFieldQueryBuilder maxQueryTerms(int maxQueryTerms) {
        this.maxQueryTerms = maxQueryTerms;
        return this;
    }

    public MoreLikeThisFieldQueryBuilder stopWords(String ... stopWords) {
        this.stopWords = stopWords;
        return this;
    }

    public MoreLikeThisFieldQueryBuilder minDocFreq(int minDocFreq) {
        this.minDocFreq = minDocFreq;
        return this;
    }

    public MoreLikeThisFieldQueryBuilder maxDocFreq(int maxDocFreq) {
        this.maxDocFreq = maxDocFreq;
        return this;
    }

    public MoreLikeThisFieldQueryBuilder minWordLen(int minWordLen) {
        this.minWordLen = minWordLen;
        return this;
    }

    public MoreLikeThisFieldQueryBuilder maxWordLen(int maxWordLen) {
        this.maxWordLen = maxWordLen;
        return this;
    }

    public MoreLikeThisFieldQueryBuilder boostTerms(float boostTerms) {
        this.boostTerms = boostTerms;
        return this;
    }

    public MoreLikeThisFieldQueryBuilder analyzer(String analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    @Override
    public MoreLikeThisFieldQueryBuilder boost(float boost) {
        this.boost = boost;
        return this;
    }

    public MoreLikeThisFieldQueryBuilder failOnUnsupportedField(boolean fail) {
        this.failOnUnsupportedField = fail;
        return this;
    }

    public MoreLikeThisFieldQueryBuilder queryName(String queryName) {
        this.queryName = queryName;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("mlt_field");
        builder.startObject(this.name);
        if (this.likeText == null) {
            throw new ElasticSearchIllegalArgumentException("moreLikeThisField requires 'like_text' to be provided");
        }
        builder.field("like_text", this.likeText);
        if (this.percentTermsToMatch != -1.0f) {
            builder.field("percent_terms_to_match", this.percentTermsToMatch);
        }
        if (this.minTermFreq != -1) {
            builder.field("min_term_freq", this.minTermFreq);
        }
        if (this.maxQueryTerms != -1) {
            builder.field("max_query_terms", this.maxQueryTerms);
        }
        if (this.stopWords != null && this.stopWords.length > 0) {
            builder.startArray("stop_words");
            for (String stopWord : this.stopWords) {
                builder.value(stopWord);
            }
            builder.endArray();
        }
        if (this.minDocFreq != -1) {
            builder.field("min_doc_freq", this.minDocFreq);
        }
        if (this.maxDocFreq != -1) {
            builder.field("max_doc_freq", this.maxDocFreq);
        }
        if (this.minWordLen != -1) {
            builder.field("min_word_len", this.minWordLen);
        }
        if (this.maxWordLen != -1) {
            builder.field("max_word_len", this.maxWordLen);
        }
        if (this.boostTerms != -1.0f) {
            builder.field("boost_terms", this.boostTerms);
        }
        if (this.boost != -1.0f) {
            builder.field("boost", this.boost);
        }
        if (this.analyzer != null) {
            builder.field("analyzer", this.analyzer);
        }
        if (this.failOnUnsupportedField != null) {
            builder.field("fail_on_unsupported_field", (Object)this.failOnUnsupportedField);
        }
        if (this.queryName != null) {
            builder.field("_name", this.queryName);
        }
        builder.endObject();
        builder.endObject();
    }
}

