/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.search.Filter;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.LimitFilter;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.FilterParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParsingException;

public class LimitFilterParser
implements FilterParser {
    public static final String NAME = "limit";

    @Inject
    public LimitFilterParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME};
    }

    @Override
    public Filter parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token2;
        XContentParser parser = parseContext.parser();
        int limit = -1;
        String currentFieldName = null;
        while ((token2 = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token2 == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (!token2.isValue()) continue;
            if ("value".equals(currentFieldName)) {
                limit = parser.intValue();
                continue;
            }
            throw new QueryParsingException(parseContext.index(), "[limit] filter does not support [" + currentFieldName + "]");
        }
        if (limit == -1) {
            throw new QueryParsingException(parseContext.index(), "No value specified for limit filter");
        }
        return new LimitFilter(limit);
    }
}

