/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.CloseableThreadLocal;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.cache.recycler.CacheRecycler;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AnalysisService;
import org.elasticsearch.index.cache.IndexCache;
import org.elasticsearch.index.engine.IndexEngine;
import org.elasticsearch.index.fielddata.IndexFieldDataService;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.FilterParser;
import org.elasticsearch.index.query.FilterParserFactory;
import org.elasticsearch.index.query.ParsedFilter;
import org.elasticsearch.index.query.ParsedQuery;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParserFactory;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.similarity.SimilarityService;
import org.elasticsearch.indices.query.IndicesQueriesRegistry;
import org.elasticsearch.script.ScriptService;

public class IndexQueryParserService
extends AbstractIndexComponent {
    private CloseableThreadLocal<QueryParseContext> cache = new CloseableThreadLocal<QueryParseContext>(){

        @Override
        protected QueryParseContext initialValue() {
            return new QueryParseContext(IndexQueryParserService.this.index, IndexQueryParserService.this);
        }
    };
    final CacheRecycler cacheRecycler;
    final AnalysisService analysisService;
    final ScriptService scriptService;
    final MapperService mapperService;
    final SimilarityService similarityService;
    final IndexCache indexCache;
    final IndexFieldDataService fieldDataService;
    final IndexEngine indexEngine;
    private final Map<String, QueryParser> queryParsers;
    private final Map<String, FilterParser> filterParsers;
    private String defaultField;
    private boolean queryStringLenient;

    @Inject
    public IndexQueryParserService(Index index, @IndexSettings Settings indexSettings, IndicesQueriesRegistry indicesQueriesRegistry, CacheRecycler cacheRecycler, ScriptService scriptService, AnalysisService analysisService, MapperService mapperService, IndexCache indexCache, IndexFieldDataService fieldDataService, IndexEngine indexEngine, @Nullable SimilarityService similarityService, @Nullable Map<String, QueryParserFactory> namedQueryParsers, @Nullable Map<String, FilterParserFactory> namedFilterParsers) {
        super(index, indexSettings);
        this.cacheRecycler = cacheRecycler;
        this.scriptService = scriptService;
        this.analysisService = analysisService;
        this.mapperService = mapperService;
        this.similarityService = similarityService;
        this.indexCache = indexCache;
        this.fieldDataService = fieldDataService;
        this.indexEngine = indexEngine;
        this.defaultField = indexSettings.get("index.query.default_field", "_all");
        this.queryStringLenient = indexSettings.getAsBoolean("index.query_string.lenient", (Boolean)false);
        ArrayList<QueryParser> queryParsers = Lists.newArrayList();
        if (namedQueryParsers != null) {
            Map<String, Settings> queryParserGroups = indexSettings.getGroups("index.queryparser.query");
            for (Map.Entry<String, QueryParserFactory> entry2 : namedQueryParsers.entrySet()) {
                String queryParserName = entry2.getKey();
                QueryParserFactory queryParserFactory = entry2.getValue();
                Settings queryParserSettings = queryParserGroups.get(queryParserName);
                if (queryParserSettings == null) {
                    queryParserSettings = ImmutableSettings.Builder.EMPTY_SETTINGS;
                }
                queryParsers.add(queryParserFactory.create(queryParserName, queryParserSettings));
            }
        }
        HashMap<String, QueryParser> queryParsersMap = Maps.newHashMap();
        queryParsersMap.putAll(indicesQueriesRegistry.queryParsers());
        if (queryParsers != null) {
            for (QueryParser queryParser : queryParsers) {
                this.add(queryParsersMap, queryParser);
            }
        }
        this.queryParsers = ImmutableMap.copyOf(queryParsersMap);
        ArrayList<FilterParser> filterParsers = Lists.newArrayList();
        if (namedFilterParsers != null) {
            Map<String, Settings> filterParserGroups = indexSettings.getGroups("index.queryparser.filter");
            for (Map.Entry<String, FilterParserFactory> entry3 : namedFilterParsers.entrySet()) {
                String filterParserName = entry3.getKey();
                FilterParserFactory filterParserFactory = entry3.getValue();
                Settings filterParserSettings = filterParserGroups.get(filterParserName);
                if (filterParserSettings == null) {
                    filterParserSettings = ImmutableSettings.Builder.EMPTY_SETTINGS;
                }
                filterParsers.add(filterParserFactory.create(filterParserName, filterParserSettings));
            }
        }
        HashMap<String, FilterParser> filterParsersMap = Maps.newHashMap();
        filterParsersMap.putAll(indicesQueriesRegistry.filterParsers());
        if (filterParsers != null) {
            for (FilterParser filterParser : filterParsers) {
                this.add(filterParsersMap, filterParser);
            }
        }
        this.filterParsers = ImmutableMap.copyOf(filterParsersMap);
    }

    public void close() {
        this.cache.close();
    }

    public String defaultField() {
        return this.defaultField;
    }

    public boolean queryStringLenient() {
        return this.queryStringLenient;
    }

    public QueryParser queryParser(String name) {
        return this.queryParsers.get(name);
    }

    public FilterParser filterParser(String name) {
        return this.filterParsers.get(name);
    }

    public ParsedQuery parse(QueryBuilder queryBuilder) throws ElasticSearchException {
        XContentParser parser = null;
        try {
            BytesReference bytes = queryBuilder.buildAsBytes();
            parser = XContentFactory.xContent(bytes).createParser(bytes);
            ParsedQuery parsedQuery = this.parse(this.cache.get(), parser);
            return parsedQuery;
        }
        catch (QueryParsingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QueryParsingException(this.index, "Failed to parse", e);
        }
        finally {
            if (parser != null) {
                parser.close();
            }
        }
    }

    public ParsedQuery parse(byte[] source) throws ElasticSearchException {
        return this.parse(source, 0, source.length);
    }

    public ParsedQuery parse(byte[] source, int offset, int length) throws ElasticSearchException {
        XContentParser parser = null;
        try {
            parser = XContentFactory.xContent(source, offset, length).createParser(source, offset, length);
            ParsedQuery parsedQuery = this.parse(this.cache.get(), parser);
            return parsedQuery;
        }
        catch (QueryParsingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QueryParsingException(this.index, "Failed to parse", e);
        }
        finally {
            if (parser != null) {
                parser.close();
            }
        }
    }

    public ParsedQuery parse(BytesReference source) throws ElasticSearchException {
        XContentParser parser = null;
        try {
            parser = XContentFactory.xContent(source).createParser(source);
            ParsedQuery parsedQuery = this.parse(this.cache.get(), parser);
            return parsedQuery;
        }
        catch (QueryParsingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QueryParsingException(this.index, "Failed to parse", e);
        }
        finally {
            if (parser != null) {
                parser.close();
            }
        }
    }

    public ParsedQuery parse(String source) throws QueryParsingException {
        XContentParser parser = null;
        try {
            parser = XContentFactory.xContent(source).createParser(source);
            ParsedQuery parsedQuery = this.parse(this.cache.get(), parser);
            return parsedQuery;
        }
        catch (QueryParsingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QueryParsingException(this.index, "Failed to parse [" + source + "]", e);
        }
        finally {
            if (parser != null) {
                parser.close();
            }
        }
    }

    public ParsedQuery parse(XContentParser parser) {
        try {
            return this.parse(this.cache.get(), parser);
        }
        catch (IOException e) {
            throw new QueryParsingException(this.index, "Failed to parse", e);
        }
    }

    @Nullable
    public ParsedFilter parseInnerFilter(XContentParser parser) throws IOException {
        QueryParseContext context = this.cache.get();
        context.reset(parser);
        Filter filter2 = context.parseInnerFilter();
        if (filter2 == null) {
            return null;
        }
        return new ParsedFilter(filter2, context.copyNamedFilters());
    }

    @Nullable
    public Query parseInnerQuery(XContentParser parser) throws IOException {
        QueryParseContext context = this.cache.get();
        context.reset(parser);
        return context.parseInnerQuery();
    }

    private ParsedQuery parse(QueryParseContext parseContext, XContentParser parser) throws IOException, QueryParsingException {
        parseContext.reset(parser);
        Query query = parseContext.parseInnerQuery();
        if (query == null) {
            query = Queries.NO_MATCH_QUERY;
        }
        return new ParsedQuery(query, parseContext.copyNamedFilters());
    }

    private void add(Map<String, FilterParser> map2, FilterParser filterParser) {
        for (String name : filterParser.names()) {
            map2.put(name.intern(), filterParser);
        }
    }

    private void add(Map<String, QueryParser> map2, QueryParser queryParser) {
        for (String name : queryParser.names()) {
            map2.put(name.intern(), queryParser);
        }
    }

    public static final class Defaults {
        public static final String QUERY_PREFIX = "index.queryparser.query";
        public static final String FILTER_PREFIX = "index.queryparser.filter";
    }
}

