/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.util.LinkedList;
import java.util.Map;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.Scopes;
import org.elasticsearch.common.inject.assistedinject.FactoryProvider;
import org.elasticsearch.common.inject.multibindings.MapBinder;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.query.FilterParser;
import org.elasticsearch.index.query.FilterParserFactory;
import org.elasticsearch.index.query.IndexQueryParserService;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParserFactory;

public class IndexQueryParserModule
extends AbstractModule {
    private final Settings settings;
    private final LinkedList<QueryParsersProcessor> processors = Lists.newLinkedList();
    private final Map<String, Class<? extends QueryParser>> queries = Maps.newHashMap();
    private final Map<String, Class<? extends FilterParser>> filters = Maps.newHashMap();

    public IndexQueryParserModule(Settings settings) {
        this.settings = settings;
    }

    public void addQueryParser(String name, Class<? extends QueryParser> queryParser) {
        this.queries.put(name, queryParser);
    }

    public void addFilterParser(String name, Class<? extends FilterParser> filterParser) {
        this.filters.put(name, filterParser);
    }

    public IndexQueryParserModule addProcessor(QueryParsersProcessor processor) {
        this.processors.addFirst(processor);
        return this;
    }

    @Override
    protected void configure() {
        this.bind(IndexQueryParserService.class).asEagerSingleton();
        MapBinder<String, QueryParserFactory> queryBinder = MapBinder.newMapBinder(this.binder(), String.class, QueryParserFactory.class);
        Map<String, Settings> xContentQueryParserGroups = this.settings.getGroups("index.queryparser.query");
        for (Map.Entry<String, Settings> entry2 : xContentQueryParserGroups.entrySet()) {
            String string2 = entry2.getKey();
            Settings qSettings = entry2.getValue();
            Class type = qSettings.getAsClass("type", null);
            if (type == null) {
                throw new IllegalArgumentException("Query Parser [" + string2 + "] must be provided with a type");
            }
            queryBinder.addBinding(string2).toProvider(FactoryProvider.newFactory(QueryParserFactory.class, qSettings.getAsClass("type", null))).in(Scopes.SINGLETON);
        }
        QueryParsersProcessor.XContentQueryParsersBindings xContentQueryParsersBindings = new QueryParsersProcessor.XContentQueryParsersBindings(queryBinder, xContentQueryParserGroups);
        for (QueryParsersProcessor queryParsersProcessor : this.processors) {
            queryParsersProcessor.processXContentQueryParsers(xContentQueryParsersBindings);
        }
        for (Map.Entry entry2 : this.queries.entrySet()) {
            queryBinder.addBinding((String)entry2.getKey()).toProvider(FactoryProvider.newFactory(QueryParserFactory.class, (Class)entry2.getValue())).in(Scopes.SINGLETON);
        }
        MapBinder<String, FilterParserFactory> filterBinder = MapBinder.newMapBinder(this.binder(), String.class, FilterParserFactory.class);
        Map<String, Settings> map2 = this.settings.getGroups("index.queryparser.filter");
        for (Map.Entry<String, Settings> entry4 : map2.entrySet()) {
            String string3 = entry4.getKey();
            Settings fSettings = entry4.getValue();
            Class type = fSettings.getAsClass("type", null);
            if (type == null) {
                throw new IllegalArgumentException("Filter Parser [" + string3 + "] must be provided with a type");
            }
            filterBinder.addBinding(string3).toProvider(FactoryProvider.newFactory(FilterParserFactory.class, fSettings.getAsClass("type", null))).in(Scopes.SINGLETON);
        }
        QueryParsersProcessor.XContentFilterParsersBindings xContentFilterParsersBindings = new QueryParsersProcessor.XContentFilterParsersBindings(filterBinder, map2);
        for (QueryParsersProcessor queryParsersProcessor : this.processors) {
            queryParsersProcessor.processXContentFilterParsers(xContentFilterParsersBindings);
        }
        for (Map.Entry entry3 : this.filters.entrySet()) {
            filterBinder.addBinding((String)entry3.getKey()).toProvider(FactoryProvider.newFactory(FilterParserFactory.class, (Class)entry3.getValue())).in(Scopes.SINGLETON);
        }
    }

    public static class QueryParsersProcessor {
        public void processXContentQueryParsers(XContentQueryParsersBindings bindings) {
        }

        public void processXContentFilterParsers(XContentFilterParsersBindings bindings) {
        }

        public static class XContentFilterParsersBindings {
            private final MapBinder<String, FilterParserFactory> binder;
            private final Map<String, Settings> groupSettings;

            public XContentFilterParsersBindings(MapBinder<String, FilterParserFactory> binder, Map<String, Settings> groupSettings) {
                this.binder = binder;
                this.groupSettings = groupSettings;
            }

            public MapBinder<String, FilterParserFactory> binder() {
                return this.binder;
            }

            public Map<String, Settings> groupSettings() {
                return this.groupSettings;
            }

            public void processXContentQueryFilter(String name, Class<? extends FilterParser> xcontentFilterParser) {
                if (!this.groupSettings.containsKey(name)) {
                    this.binder.addBinding(name).toProvider(FactoryProvider.newFactory(FilterParserFactory.class, xcontentFilterParser)).in(Scopes.SINGLETON);
                }
            }
        }

        public static class XContentQueryParsersBindings {
            private final MapBinder<String, QueryParserFactory> binder;
            private final Map<String, Settings> groupSettings;

            public XContentQueryParsersBindings(MapBinder<String, QueryParserFactory> binder, Map<String, Settings> groupSettings) {
                this.binder = binder;
                this.groupSettings = groupSettings;
            }

            public MapBinder<String, QueryParserFactory> binder() {
                return this.binder;
            }

            public Map<String, Settings> groupSettings() {
                return this.groupSettings;
            }

            public void processXContentQueryParser(String name, Class<? extends QueryParser> xcontentQueryParser) {
                if (!this.groupSettings.containsKey(name)) {
                    this.binder.addBinding(name).toProvider(FactoryProvider.newFactory(QueryParserFactory.class, xcontentQueryParser)).in(Scopes.SINGLETON);
                }
            }
        }
    }
}

